/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.manipulation;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.model.ProductConfiguration;
import org.eclipse.tycho.versions.engine.MetadataManipulator;
import org.eclipse.tycho.versions.engine.PomVersionChange;
import org.eclipse.tycho.versions.engine.ProjectMetadata;
import org.eclipse.tycho.versions.engine.VersionChangesDescriptor;
import org.eclipse.tycho.versions.engine.Versions;
import org.eclipse.tycho.versions.manipulation.ProductFileManipulator;
import org.eclipse.tycho.versions.pom.PomFile;

@Component(role=MetadataManipulator.class, hint="eclipse-application")
public class EclipseApplicationProductFileManipulator
extends ProductFileManipulator {
    @Override
    public void applyChanges(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        if (this.isEclipseApplication(project)) {
            for (PomVersionChange change : versionChangeContext.getVersionChanges()) {
                this.applyChangeToProduct(project, this.getProductConfiguration(project), this.getProductFileName(project), change);
            }
        }
    }

    @Override
    public Collection<String> validateChanges(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        if (this.isEclipseApplication(project)) {
            for (PomVersionChange change : versionChangeContext.getVersionChanges()) {
                ProductConfiguration product = this.getProductConfiguration(project);
                if (!this.isSameProject(project, change.getProject()) || !change.getVersion().equals(product.getVersion())) continue;
                String error = Versions.validateOsgiVersion(change.getNewVersion(), this.getProductFile(project));
                return error != null ? Collections.singleton(error) : null;
            }
        }
        return null;
    }

    private ProductConfiguration getProductConfiguration(ProjectMetadata project) {
        ProductConfiguration product = project.getMetadata(ProductConfiguration.class);
        if (product == null) {
            File file = this.getProductFile(project);
            try {
                product = ProductConfiguration.read((File)file);
                project.putMetadata(product);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read product configuration file " + file, e);
            }
        }
        return product;
    }

    private File getProductFile(ProjectMetadata project) {
        return new File(project.getBasedir(), this.getProductFileName(project));
    }

    private String getProductFileName(ProjectMetadata project) {
        PomFile pom = project.getMetadata(PomFile.class);
        return pom.getArtifactId() + ".product";
    }

    private boolean isEclipseApplication(ProjectMetadata project) {
        String packaging = project.getMetadata(PomFile.class).getPackaging();
        return this.isEclipseApplication(packaging);
    }

    private boolean isEclipseApplication(String packaging) {
        return "eclipse-application".equals(packaging);
    }

    @Override
    public void writeMetadata(ProjectMetadata project) throws IOException {
        ProductConfiguration product = project.getMetadata(ProductConfiguration.class);
        if (product != null) {
            ProductConfiguration.write((ProductConfiguration)product, (File)this.getProductFile(project));
        }
    }
}

