/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.sisu.equinox.launching.BundleStartLevel;
import org.eclipse.sisu.equinox.launching.DefaultEquinoxInstallationDescription;
import org.eclipse.sisu.equinox.launching.EquinoxInstallation;
import org.eclipse.sisu.equinox.launching.EquinoxInstallationDescription;
import org.eclipse.sisu.equinox.launching.EquinoxInstallationFactory;
import org.eclipse.sisu.equinox.launching.EquinoxLauncher;
import org.eclipse.sisu.equinox.launching.internal.EquinoxLaunchConfiguration;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.artifacts.DependencyArtifacts;
import org.eclipse.tycho.artifacts.TargetPlatform;
import org.eclipse.tycho.core.BundleProject;
import org.eclipse.tycho.core.DependencyResolverConfiguration;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TargetPlatformResolver;
import org.eclipse.tycho.core.TychoConstants;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.facade.BuildProperties;
import org.eclipse.tycho.core.facade.BuildPropertiesParser;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.OsgiBundleProject;
import org.eclipse.tycho.core.resolver.DefaultTargetPlatformResolverFactory;
import org.eclipse.tycho.core.resolver.shared.OptionalResolutionAction;
import org.eclipse.tycho.core.utils.PlatformPropertiesUtils;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.launching.LaunchConfiguration;
import org.eclipse.tycho.launching.LaunchConfigurationFactory;
import org.eclipse.tycho.surefire.TestFramework;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMojo
extends AbstractMojo
implements LaunchConfigurationFactory {
    private File work;
    private MavenProject project;
    private int debugPort;
    private List<String> includes;
    private List<String> excludes;
    private String test;
    private boolean skipExec;
    private boolean skipTests;
    private boolean skip;
    private boolean failIfNoTests;
    private boolean testFailureIgnore;
    private File testClassesDirectory;
    private boolean showEclipseLog;
    private boolean redirectTestOutputToFile;
    private File reportsDirectory;
    private File surefireProperties;
    private File devProperties;
    private Dependency[] dependencies;
    private String application;
    private String product;
    private MavenSession session;
    private boolean useUIHarness;
    private boolean useUIThread;
    private List<Artifact> pluginArtifacts;
    private String argLine;
    private String appArgLine;
    private int forkedProcessTimeoutInSeconds;
    private String testSuite;
    private String testClass;
    private Map<String, String> environmentVariables;
    private Map<String, String> systemProperties;
    private String[] explodedBundles;
    private Dependency[] frameworkExtensions;
    private BundleStartLevel[] bundleStartLevel;
    private RepositorySystem repositorySystem;
    private ResolutionErrorHandler resolutionErrorHandler;
    private DefaultTargetPlatformResolverFactory targetPlatformResolverLocator;
    private Map<String, TychoProject> projectTypes;
    private EquinoxInstallationFactory installationFactory;
    private EquinoxLauncher launcher;
    private OsgiBundleProject osgiBundle;
    private ToolchainManager toolchainManager;
    private BuildPropertiesParser buildPropertiesParser;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipExec || this.skipTests) {
            this.getLog().info((CharSequence)"Skipping tests");
            return;
        }
        if (!"eclipse-test-plugin".equals(this.project.getPackaging())) {
            this.getLog().warn((CharSequence)("Unsupported packaging type " + this.project.getPackaging()));
            return;
        }
        if (this.testSuite != null || this.testClass != null) {
            if (this.testSuite == null || this.testClass == null) {
                throw new MojoExecutionException("Both testSuite and testClass must be provided or both should be null");
            }
            MavenProject suite = this.getTestSuite(this.testSuite);
            if (suite == null) {
                throw new MojoExecutionException("Cannot find test suite project with Bundle-SymbolicName " + this.testSuite);
            }
            if (!suite.equals((Object)this.project)) {
                this.getLog().info((CharSequence)("Not executing tests, testSuite=" + this.testSuite + " and project is not the testSuite"));
                return;
            }
        }
        EquinoxInstallation testRuntime = this.createEclipseInstallation(false, DefaultReactorProject.adapt((MavenSession)this.session));
        this.runTest(testRuntime);
    }

    private EquinoxInstallation createEclipseInstallation(boolean includeReactorProjects, List<ReactorProject> reactorProjects) throws MojoExecutionException {
        BundleProject projectType;
        String testFramework;
        TargetPlatformResolver platformResolver = this.targetPlatformResolverLocator.lookupPlatformResolver(this.project);
        TargetPlatformConfiguration configuration = TychoProjectUtils.getTargetPlatformConfiguration((MavenProject)this.project);
        final ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        if (this.dependencies != null) {
            dependencies.addAll(Arrays.asList(this.dependencies));
        }
        dependencies.addAll(configuration.getDependencyResolverConfiguration().getExtraRequirements());
        dependencies.addAll(this.getTestDependencies());
        TargetPlatform targetPlatform = platformResolver.computeTargetPlatform(this.session, this.project, reactorProjects);
        DependencyResolverConfiguration resolverConfiguration = new DependencyResolverConfiguration(){

            public OptionalResolutionAction getOptionalResolutionAction() {
                return OptionalResolutionAction.IGNORE;
            }

            public List<Dependency> getExtraRequirements() {
                return dependencies;
            }
        };
        DependencyArtifacts testRuntimeArtifacts = platformResolver.resolveDependencies(this.session, this.project, targetPlatform, reactorProjects, resolverConfiguration);
        if (testRuntimeArtifacts == null) {
            throw new MojoExecutionException("Cannot determinate build target platform location -- not executing tests");
        }
        this.work.mkdirs();
        DefaultEquinoxInstallationDescription testRuntime = new DefaultEquinoxInstallationDescription();
        testRuntime.addBundlesToExplode(this.getBundlesToExplode());
        testRuntime.addFrameworkExtensions(this.getFrameworkExtensions());
        if (this.bundleStartLevel != null) {
            for (BundleStartLevel level : this.bundleStartLevel) {
                testRuntime.addBundleStartLevel(level);
            }
        }
        if ((testFramework = new TestFramework().getTestFramework((projectType = (BundleProject)this.projectTypes.get(this.project.getPackaging())).getClasspath(this.project))) == null) {
            throw new MojoExecutionException("Could not determine test framework used by test bundle " + this.project.toString());
        }
        this.getLog().debug((CharSequence)("Using test framework " + testFramework));
        for (ArtifactDescriptor artifact : testRuntimeArtifacts.getArtifacts("eclipse-plugin")) {
            ReactorProject otherProject = artifact.getMavenProject();
            if (otherProject != null) {
                if (otherProject.sameProject((Object)this.project)) {
                    testRuntime.addBundle(artifact.getKey(), this.project.getBasedir());
                    continue;
                }
                File file = otherProject.getArtifact(artifact.getClassifier());
                if (file != null) {
                    testRuntime.addBundle(artifact.getKey(), file);
                    continue;
                }
            }
            testRuntime.addBundle(artifact);
        }
        Set<File> surefireBundles = this.getSurefirePlugins(testFramework);
        for (File file : surefireBundles) {
            testRuntime.addBundle(this.getBundleArtifacyKey(file), file, true);
        }
        this.createDevProperties(includeReactorProjects, reactorProjects);
        this.createSurefireProperties(projectType.getArtifactKey(DefaultReactorProject.adapt((MavenProject)this.project)).getId(), testFramework);
        this.reportsDirectory.mkdirs();
        return this.installationFactory.createInstallation((EquinoxInstallationDescription)testRuntime, this.work);
    }

    private ArtifactKey getBundleArtifacyKey(File file) throws MojoExecutionException {
        ArtifactKey key = this.osgiBundle.readArtifactKey(file);
        if (key == null) {
            throw new MojoExecutionException("Not an OSGi bundle " + file.getAbsolutePath());
        }
        return key;
    }

    private MavenProject getTestSuite(String symbolicName) {
        for (MavenProject otherProject : this.session.getProjects()) {
            TychoProject projectType = this.projectTypes.get(otherProject.getPackaging());
            if (projectType == null || !projectType.getArtifactKey(DefaultReactorProject.adapt((MavenProject)otherProject)).getId().equals(symbolicName)) continue;
            return otherProject;
        }
        return null;
    }

    private List<Dependency> getTestDependencies() {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        result.add(this.newBundleDependency("org.eclipse.osgi"));
        result.add(this.newBundleDependency("org.eclipse.equinox.launcher"));
        if (this.useUIHarness) {
            result.add(this.newBundleDependency("org.eclipse.ui.ide.application"));
        } else {
            result.add(this.newBundleDependency("org.eclipse.core.runtime"));
        }
        return result;
    }

    protected Dependency newBundleDependency(String bundleId) {
        Dependency ideapp = new Dependency();
        ideapp.setArtifactId(bundleId);
        ideapp.setType("eclipse-plugin");
        return ideapp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSurefireProperties(String symbolicName, String testFramework) throws MojoExecutionException {
        Properties p = new Properties();
        p.put("testpluginname", symbolicName);
        p.put("testclassesdirectory", this.testClassesDirectory.getAbsolutePath());
        p.put("reportsdirectory", this.reportsDirectory.getAbsolutePath());
        p.put("testprovider", this.getTestProvider(testFramework));
        p.put("redirectTestOutputToFile", String.valueOf(this.redirectTestOutputToFile));
        if (this.test != null) {
            String test = this.test;
            test = (test = test.replace('.', '/')).endsWith(".class") ? test : test + ".class";
            test = test.startsWith("**/") ? test : "**/" + test;
            p.put("includes", test);
        } else if (this.testClass != null) {
            p.put("includes", this.testClass.replace('.', '/') + ".class");
        } else {
            p.put("includes", this.includes != null ? this.getIncludesExcludes(this.includes) : "**/Test*.class,**/*Test.class,**/*TestCase.class");
            p.put("excludes", this.excludes != null ? this.getIncludesExcludes(this.excludes) : "**/Abstract*Test.class,**/Abstract*TestCase.class,**/*$*");
        }
        p.put("failifnotests", String.valueOf(this.failIfNoTests));
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.surefireProperties));
            try {
                p.store(out, null);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't write test launcher properties file", (Exception)e);
        }
    }

    private String getTestProvider(String testFramework) {
        if ("org.junit".equals(testFramework)) {
            return "org.apache.maven.surefire.junit.JUnit3Provider";
        }
        if ("org.junit4".equals(testFramework)) {
            return "org.apache.maven.surefire.junit4.JUnit4Provider";
        }
        throw new IllegalArgumentException();
    }

    private String getIncludesExcludes(List<String> patterns) {
        StringBuilder sb = new StringBuilder();
        for (String pattern : patterns) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(pattern);
        }
        return sb.toString();
    }

    private void runTest(EquinoxInstallation testRuntime) throws MojoExecutionException, MojoFailureException {
        int result;
        try {
            File workspace = new File(this.work, "data").getAbsoluteFile();
            FileUtils.deleteDirectory((File)workspace);
            LaunchConfiguration cli = this.createCommandLine(testRuntime, workspace);
            this.getLog().info((CharSequence)("Expected eclipse log file: " + new File(workspace, ".metadata/.log").getCanonicalPath()));
            result = this.launcher.execute(cli, this.forkedProcessTimeoutInSeconds);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while executing platform", e);
        }
        switch (result) {
            case 0: {
                this.getLog().info((CharSequence)"All tests passed!");
                break;
            }
            case 254: {
                String message = "No tests found.";
                if (this.failIfNoTests) {
                    throw new MojoFailureException(message);
                }
                this.getLog().warn((CharSequence)message);
                break;
            }
            default: {
                String errorMessage = "There are test failures.\n\nPlease refer to " + this.reportsDirectory + " for the individual test results.";
                if (this.testFailureIgnore) {
                    this.getLog().error((CharSequence)errorMessage);
                    break;
                }
                throw new MojoFailureException(errorMessage);
            }
        }
    }

    private Toolchain getToolchain() {
        Toolchain tc = null;
        if (this.toolchainManager != null) {
            tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        }
        return tc;
    }

    LaunchConfiguration createCommandLine(EquinoxInstallation testRuntime, File workspace) throws MalformedURLException {
        EquinoxLaunchConfiguration cli = new EquinoxLaunchConfiguration(testRuntime);
        String executable = null;
        Toolchain tc = this.getToolchain();
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in tycho-surefire-plugin: " + tc));
            executable = tc.findTool("java");
        }
        cli.setJvmExecutable(executable);
        cli.setWorkingDirectory(this.project.getBasedir());
        if (this.debugPort > 0) {
            cli.addVMArguments(new String[]{"-Xdebug", "-Xrunjdwp:transport=dt_socket,address=" + this.debugPort + ",server=y,suspend=y"});
        }
        cli.addVMArguments(new String[]{"-Dosgi.noShutdown=false"});
        Properties properties = (Properties)this.project.getContextValue(TychoConstants.CTX_MERGED_PROPERTIES);
        cli.addVMArguments(new String[]{"-Dosgi.os=" + PlatformPropertiesUtils.getOS((Properties)properties), "-Dosgi.ws=" + PlatformPropertiesUtils.getWS((Properties)properties), "-Dosgi.arch=" + PlatformPropertiesUtils.getArch((Properties)properties)});
        this.addVMArgs(cli, this.argLine);
        if (this.systemProperties != null) {
            for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
                cli.addVMArguments(true, new String[]{"-D" + entry.getKey() + "=" + entry.getValue()});
            }
        }
        if (this.getLog().isDebugEnabled() || this.showEclipseLog) {
            cli.addProgramArguments(new String[]{"-debug", "-consolelog"});
        }
        this.addProgramArgs(true, cli, "-data", workspace.getAbsolutePath(), "-dev", this.devProperties.toURI().toURL().toExternalForm(), "-install", testRuntime.getLocation().getAbsolutePath(), "-configuration", new File(this.work, "configuration").getAbsolutePath(), "-application", this.getTestApplication(testRuntime.getInstallationDescription()), "-testproperties", this.surefireProperties.getAbsolutePath());
        if (this.application != null) {
            cli.addProgramArguments(new String[]{"-testApplication", this.application});
        }
        if (this.product != null) {
            cli.addProgramArguments(new String[]{"-product", this.product});
        }
        if (this.useUIHarness && !this.useUIThread) {
            cli.addProgramArguments(new String[]{"-nouithread"});
        }
        this.addProgramArgs(false, cli, this.appArgLine);
        if (this.environmentVariables != null) {
            cli.addEnvironmentVariables(this.environmentVariables);
        }
        return cli;
    }

    void addProgramArgs(boolean escape, EquinoxLaunchConfiguration cli, String ... arguments) {
        if (arguments != null) {
            for (String argument : arguments) {
                if (argument == null) continue;
                cli.addProgramArguments(escape, new String[]{argument});
            }
        }
    }

    void addVMArgs(EquinoxLaunchConfiguration cli, String argLine) {
        if (argLine != null) {
            cli.addVMArguments(false, new String[]{argLine});
        }
    }

    private String getTestApplication(EquinoxInstallationDescription testRuntime) {
        if (this.useUIHarness) {
            ArtifactDescriptor systemBundle = testRuntime.getSystemBundle();
            Version osgiVersion = Version.parseVersion((String)systemBundle.getKey().getVersion());
            if (osgiVersion.compareTo(EquinoxInstallationDescription.EQUINOX_VERSION_3_3_0) < 0) {
                return "org.eclipse.tycho.surefire.osgibooter.uitest32";
            }
            return "org.eclipse.tycho.surefire.osgibooter.uitest";
        }
        return "org.eclipse.tycho.surefire.osgibooter.headlesstest";
    }

    private Set<File> getSurefirePlugins(String testFramework) throws MojoExecutionException {
        String fragment;
        LinkedHashSet<File> result = new LinkedHashSet<File>();
        if ("org.junit".equals(testFramework)) {
            fragment = "org.eclipse.tycho.surefire.junit";
        } else if ("org.junit4".equals(testFramework)) {
            fragment = "org.eclipse.tycho.surefire.junit4";
        } else {
            throw new IllegalArgumentException("Unsupported test framework " + testFramework);
        }
        for (Artifact artifact : this.pluginArtifacts) {
            if (!"org.eclipse.tycho".equals(artifact.getGroupId()) || !"org.eclipse.tycho.surefire.osgibooter".equals(artifact.getArtifactId()) && !fragment.equals(artifact.getArtifactId())) continue;
            result.add(artifact.getFile());
        }
        if (result.size() != 2) {
            StringBuilder sb = new StringBuilder("Unable to locate org.eclipse.tycho:org.eclipse.tycho.surefire.osgibooter and/or its fragments\n");
            sb.append("Test framework: " + testFramework);
            sb.append("All plugin artifacts: ");
            for (Artifact artifact : this.pluginArtifacts) {
                sb.append("\n\t").append(artifact.toString());
            }
            sb.append("\nMatched OSGi test booter artifacts: ");
            for (File file : result) {
                sb.append("\n\t").append(file.getAbsolutePath());
            }
            throw new MojoExecutionException(sb.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDevProperties(boolean includeReactorProjects, List<ReactorProject> reactorProjects) throws MojoExecutionException {
        Properties dev = new Properties();
        if (includeReactorProjects) {
            dev.put("@ignoredot@", "true");
            for (ReactorProject otherProject : reactorProjects) {
                if (!"eclipse-test-plugin".equals(otherProject.getPackaging()) && !"eclipse-plugin".equals(otherProject.getPackaging())) continue;
                TychoProject projectType = this.projectTypes.get(otherProject.getPackaging());
                dev.put(projectType.getArtifactKey(otherProject).getId(), this.getBuildOutputDirectories(otherProject));
            }
        }
        ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)this.project);
        TychoProject projectType = this.projectTypes.get(this.project.getPackaging());
        dev.put(projectType.getArtifactKey(reactorProject).getId(), this.getBuildOutputDirectories(reactorProject));
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.devProperties));
            try {
                dev.store(os, null);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't create osgi dev properties file", (Exception)e);
        }
    }

    private String getBuildOutputDirectories(ReactorProject otherProject) {
        StringBuilder sb = new StringBuilder();
        sb.append(otherProject.getOutputDirectory());
        sb.append(',').append(otherProject.getTestOutputDirectory());
        BuildProperties buildProperties = this.buildPropertiesParser.parse(otherProject.getBasedir());
        for (Map.Entry outputEntry : buildProperties.getJarToOutputFolderMap().entrySet()) {
            if (".".equals(outputEntry.getKey())) continue;
            TestMojo.appendCommaSeparated(sb, (String)outputEntry.getValue());
        }
        for (Map.Entry sourceEntry : buildProperties.getJarToSourceFolderMap().entrySet()) {
            String fileName = (String)sourceEntry.getKey();
            if (".".equals(fileName)) continue;
            String classesDir = otherProject.getBuildDirectory().getName() + "/" + fileName.substring(0, fileName.length() - ".jar".length()) + "-classes";
            TestMojo.appendCommaSeparated(sb, classesDir);
        }
        return sb.toString();
    }

    private static void appendCommaSeparated(StringBuilder sb, String string) {
        if (sb.length() > 0) {
            sb.append(',');
        }
        sb.append(string);
    }

    private List<String> getBundlesToExplode() {
        ArrayList<String> bundles = new ArrayList<String>();
        if (this.explodedBundles != null) {
            bundles.addAll(Arrays.asList(this.explodedBundles));
        }
        return bundles;
    }

    private List<File> getFrameworkExtensions() throws MojoExecutionException {
        ArrayList<File> files = new ArrayList<File>();
        if (this.frameworkExtensions != null) {
            for (Dependency frameworkExtension : this.frameworkExtensions) {
                Artifact artifact = this.repositorySystem.createDependencyArtifact(frameworkExtension);
                ArtifactResolutionRequest request = new ArtifactResolutionRequest();
                request.setArtifact(artifact);
                request.setResolveRoot(true).setResolveTransitively(false);
                request.setLocalRepository(this.session.getLocalRepository());
                request.setRemoteRepositories(this.project.getPluginArtifactRepositories());
                request.setOffline(this.session.isOffline());
                request.setForceUpdate(this.session.getRequest().isUpdateSnapshots());
                ArtifactResolutionResult result = this.repositorySystem.resolve(request);
                try {
                    this.resolutionErrorHandler.throwErrors(request, result);
                }
                catch (ArtifactResolutionException e) {
                    throw new MojoExecutionException("Failed to resolve framework extension " + frameworkExtension.getManagementKey(), (Exception)((Object)e));
                }
                files.add(artifact.getFile());
            }
        }
        return files;
    }

    public LaunchConfiguration createLaunchConfiguration(List<ReactorProject> reactorProjects) {
        try {
            EquinoxInstallation testRuntime = this.createEclipseInstallation(true, reactorProjects);
            return this.createCommandLine(testRuntime, this.work);
        }
        catch (MalformedURLException e) {
            this.getLog().error((Throwable)e);
        }
        catch (MojoExecutionException e) {
            this.getLog().error((Throwable)e);
        }
        return null;
    }
}

