/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging;

import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.ModelWriter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.PackagingType;
import org.eclipse.tycho.packaging.reverseresolve.ArtifactCoordinateResolver;

@Mojo(name="update-consumer-pom", threadSafe=true, defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.TEST)
public class UpdateConsumerPomMojo
extends AbstractMojo {
    private static final String POLYGLOT_POM_TYCHO = ".polyglot.pom.tycho";
    @Parameter(property="project", readonly=true)
    protected MavenProject project;
    @Component(role=ModelWriter.class)
    protected ModelWriter modelWriter;
    @Component(role=ModelReader.class)
    protected ModelReader modelReader;
    @Component
    private Map<String, ArtifactCoordinateResolver> artifactCoordinateResolvers;
    @Parameter(defaultValue="${project.basedir}", required=true)
    protected File outputDirectory;
    @Parameter(defaultValue=".tycho-consumer-pom.xml", required=true)
    protected String tychoPomFilename;
    @Parameter(defaultValue="true")
    protected boolean deleteOnExit = true;
    @Parameter
    protected Boolean skipPomGeneration;
    @Parameter(defaultValue="true")
    protected boolean updatePomFile = true;
    @Parameter(defaultValue="false")
    protected boolean includeP2Dependencies = false;
    @Parameter(defaultValue="false")
    protected boolean mapP2Dependencies = false;
    @Parameter(defaultValue="false")
    protected boolean replacePackagingType = false;
    @Parameter(defaultValue="true")
    protected boolean replaceTypeWithExtension = false;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(defaultValue="local,central")
    private String resolver;
    private Map<String, Optional<Dependency>> resolvedDependencies = new HashMap<String, Optional<Dependency>>();
    @Component
    ArtifactHandlerManager artifactHandlerManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String relativePath;
        Model projectModel;
        if (this.skipPomGeneration == null ? !this.archive.isAddMavenDescriptor() : this.skipPomGeneration != false) {
            return;
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = this.project.getBasedir();
        }
        this.getLog().debug((CharSequence)"Generate pom descriptor with updated dependencies...");
        try {
            projectModel = this.modelReader.read(this.project.getFile(), null);
        }
        catch (IOException e) {
            throw new MojoExecutionException("reading the model failed!", (Exception)e);
        }
        List dependencies = projectModel.getDependencies();
        dependencies.clear();
        List<Dependency> list = Objects.requireNonNullElse(this.project.getDependencies(), Collections.emptyList());
        for (Dependency dep : list) {
            ArtifactHandler handler;
            Dependency copy = dep.clone();
            if ("system".equals(dep.getScope()) && !this.handleSystemScopeDependency(copy)) continue;
            if (this.replaceTypeWithExtension && PackagingType.TYCHO_PACKAGING_TYPES.contains(copy.getType()) && (handler = this.artifactHandlerManager.getArtifactHandler(copy.getType())) != null) {
                copy.setType(handler.getExtension());
            }
            dependencies.add(copy);
        }
        Parent parent = projectModel.getParent();
        if (parent != null && (relativePath = parent.getRelativePath()) != null && relativePath.endsWith(POLYGLOT_POM_TYCHO)) {
            parent.setRelativePath(relativePath.substring(0, relativePath.length() - POLYGLOT_POM_TYCHO.length()) + "pom.xml");
        }
        if (this.replacePackagingType) {
            projectModel.setPackaging(this.mapTychoPackagingTypeToMaven(projectModel.getPackaging()));
        }
        File output = new File(this.outputDirectory, this.tychoPomFilename);
        if (this.deleteOnExit) {
            output.deleteOnExit();
        }
        try {
            this.modelWriter.write(output, null, projectModel);
        }
        catch (IOException e) {
            throw new MojoExecutionException("writing the model failed!", (Exception)e);
        }
        if (this.updatePomFile) {
            this.project.setFile(output);
        }
    }

    private String mapTychoPackagingTypeToMaven(String packaging) {
        if ("eclipse-plugin".equals(packaging) || "eclipse-test-plugin".equals(packaging)) {
            return "jar";
        }
        if ("eclipse-feature".equals(packaging)) {
            return "pom";
        }
        if ("eclipse-target-definition".equals(packaging)) {
            return "target";
        }
        if ("eclipse-repository".equals(packaging)) {
            return "zip";
        }
        return packaging;
    }

    private boolean handleSystemScopeDependency(Dependency dep) {
        if (dep.getGroupId().startsWith("p2.") || this.isEmbeddedJar(dep)) {
            Path p;
            Optional resolved;
            if (this.mapP2Dependencies && !this.isEmbeddedJar(dep) && (resolved = this.resolvedDependencies.computeIfAbsent((p = this.getPath(dep)).normalize().toString(), nil -> Arrays.stream(this.resolver.split(",")).map(String::strip).map(this.artifactCoordinateResolvers::get).filter(Objects::nonNull).flatMap(resolver -> resolver.resolve(p).stream()).findFirst())).isPresent()) {
                dep.setScope("compile");
                dep.setSystemPath(null);
                Dependency dependency = (Dependency)resolved.get();
                dep.setArtifactId(dependency.getArtifactId());
                dep.setGroupId(dependency.getGroupId());
                dep.setVersion(dependency.getVersion());
                dep.setType(dependency.getType());
                return true;
            }
            dep.setOptional(true);
            dep.setScope("provided");
            dep.setSystemPath(null);
            return this.includeP2Dependencies;
        }
        return true;
    }

    private Path getPath(Dependency dep) {
        String systemPath = dep.getSystemPath();
        if (systemPath != null) {
            try {
                return Path.of(systemPath, new String[0]).toAbsolutePath();
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean isEmbeddedJar(Dependency dep) {
        return "eclipse-plugin".equals(dep.getType()) && dep.getClassifier() != null && !dep.getClassifier().isBlank();
    }
}

