/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.TychoConstants;
import org.eclipse.tycho.core.facade.BuildProperties;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.project.BuildOutputJar;
import org.eclipse.tycho.core.osgitools.project.EclipsePluginProject;
import org.eclipse.tycho.packaging.AbstractTychoPackagingMojo;

public class PackagePluginMojo
extends AbstractTychoPackagingMojo {
    protected File buildDirectory;
    protected EclipsePluginProject pdeProject;
    private JarArchiver jarArchiver = new JarArchiver();
    protected String finalName;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();

    public void execute() throws MojoExecutionException {
        this.pdeProject = (EclipsePluginProject)this.project.getContextValue(TychoConstants.CTX_ECLIPSE_PLUGIN_PROJECT);
        this.expandVersion();
        this.createSubJars();
        File pluginFile = this.createPluginJar();
        this.project.getArtifact().setFile(pluginFile);
    }

    private void createSubJars() throws MojoExecutionException {
        BuildOutputJar dotOutputJar = this.pdeProject.getDotOutputJar();
        String dotOutputJarName = dotOutputJar != null ? dotOutputJar.getName() : ".";
        for (BuildOutputJar jar : this.pdeProject.getOutputJars()) {
            if (jar.getName().equals(dotOutputJarName)) continue;
            this.makeJar(jar.getName(), jar.getOutputDirectory());
        }
    }

    private File makeJar(String jarName, File classesFolder) throws MojoExecutionException {
        try {
            File jarFile = new File(this.project.getBasedir(), jarName);
            JarArchiver archiver = new JarArchiver();
            archiver.setDestFile(jarFile);
            archiver.addDirectory(classesFolder);
            archiver.createArchive();
            return jarFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not create jar " + jarName, e);
        }
    }

    private File createPluginJar() throws MojoExecutionException {
        try {
            File manifest;
            MavenArchiver archiver = new MavenArchiver();
            archiver.setArchiver(this.jarArchiver);
            File pluginFile = new File(this.buildDirectory, this.finalName + ".jar");
            if (pluginFile.exists()) {
                pluginFile.delete();
            }
            BuildProperties buildProperties = this.pdeProject.getBuildProperties();
            List binIncludesList = buildProperties.getBinIncludes();
            List binExcludesList = buildProperties.getBinExcludes();
            BuildOutputJar dotOutputJar = this.pdeProject.getDotOutputJar();
            if (dotOutputJar != null && binIncludesList.contains(dotOutputJar.getName())) {
                String prefix = dotOutputJar.getName().endsWith("/") ? dotOutputJar.getName() : "";
                archiver.getArchiver().addDirectory(dotOutputJar.getOutputDirectory(), prefix);
            }
            if (binIncludesList.size() > 0) {
                String dotOutputJarName = dotOutputJar != null ? dotOutputJar.getName() : ".";
                this.checkBinIncludesExist(buildProperties, dotOutputJarName);
                archiver.getArchiver().addFileSet(this.getFileSet(this.project.getBasedir(), binIncludesList, binExcludesList));
            }
            if ((manifest = this.updateManifest()).exists()) {
                this.archive.setManifestFile(manifest);
            }
            archiver.setOutputFile(pluginFile);
            if (!this.archive.isForced()) {
                this.getLog().warn((CharSequence)"ignoring unsupported archive forced = false parameter.");
                this.archive.setForced(true);
            }
            archiver.createArchive(this.project, this.archive);
            return pluginFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling JAR", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File updateManifest() throws FileNotFoundException, IOException, MojoExecutionException {
        Manifest mf;
        File mfile = new File(this.project.getBasedir(), "META-INF/MANIFEST.MF");
        FileInputStream is = new FileInputStream(mfile);
        try {
            mf = new Manifest(is);
        }
        finally {
            ((InputStream)is).close();
        }
        Attributes attributes = mf.getMainAttributes();
        if (attributes.getValue(Attributes.Name.MANIFEST_VERSION) == null) {
            attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
        ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)this.project);
        attributes.putValue("Bundle-Version", reactorProject.getExpandedVersion());
        mfile = new File(this.project.getBuild().getDirectory(), "MANIFEST.MF");
        mfile.getParentFile().mkdirs();
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(mfile));
        try {
            mf.write(os);
        }
        finally {
            os.close();
        }
        return mfile;
    }
}

