/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.artifactcomparator.ArtifactComparator;
import org.eclipse.tycho.artifactcomparator.ArtifactDelta;
import org.eclipse.tycho.core.resolver.shared.MavenRepositoryLocation;
import org.eclipse.tycho.p2.metadata.IP2Artifact;
import org.eclipse.tycho.p2.tools.baseline.facade.BaselineService;
import org.eclipse.tycho.plugins.p2.BaselineMode;
import org.eclipse.tycho.plugins.p2.BaselineReplace;
import org.eclipse.tycho.plugins.p2.Repository;
import org.eclipse.tycho.zipcomparator.internal.CompoundArtifactDelta;
import org.eclipse.tycho.zipcomparator.internal.SimpleArtifactDelta;

@Component(role=BaselineValidator.class)
public class BaselineValidator {
    @Requirement
    private Logger log;
    @Requirement(hint="zip")
    private ArtifactComparator zipComparator;
    @Requirement
    private EquinoxServiceFactory equinox;

    public Map<String, IP2Artifact> validateAndReplace(MavenProject project, MojoExecution execution, Map<String, IP2Artifact> reactorMetadata, List<Repository> baselineRepositories, BaselineMode baselineMode, BaselineReplace baselineReplace) throws IOException, MojoExecutionException {
        Map<String, IP2Artifact> result = reactorMetadata;
        if (baselineMode != BaselineMode.disable && baselineRepositories != null && !baselineRepositories.isEmpty()) {
            ArrayList<MavenRepositoryLocation> _repositories = new ArrayList<MavenRepositoryLocation>();
            for (Repository repository : baselineRepositories) {
                if (repository.getUrl() == null) continue;
                _repositories.add(new MavenRepositoryLocation(repository.getId(), repository.getUrl()));
            }
            File baselineBasedir = new File(project.getBuild().getDirectory(), "baseline");
            BaselineService baselineService = this.getService(BaselineService.class);
            Map baselineMetadata = baselineService.getProjectBaseline(_repositories, reactorMetadata, baselineBasedir);
            if (baselineMetadata != null) {
                CompoundArtifactDelta delta = this.getDelta(baselineService, baselineMetadata, reactorMetadata, execution);
                if (delta != null) {
                    if (System.getProperties().containsKey("tycho.debug.artifactcomparator")) {
                        File logdir = new File(project.getBuild().getDirectory(), "artifactcomparison");
                        this.log.info("Artifact comparison detailed log directory " + logdir.getAbsolutePath());
                        for (Map.Entry classifier : delta.getMembers().entrySet()) {
                            if (!(classifier.getValue() instanceof CompoundArtifactDelta)) continue;
                            ((CompoundArtifactDelta)classifier.getValue()).writeDetails(new File(logdir, (String)classifier.getKey()));
                        }
                    }
                    if (baselineMode == BaselineMode.fail || baselineMode == BaselineMode.failCommon && !this.isMissingOnlyDelta((ArtifactDelta)delta)) {
                        throw new MojoExecutionException(delta.getDetailedMessage());
                    }
                    this.log.warn(project.toString() + ": " + delta.getDetailedMessage());
                }
                if (baselineReplace != BaselineReplace.none) {
                    result = new LinkedHashMap<String, IP2Artifact>();
                    ArrayList<String> replaced = new ArrayList<String>();
                    for (Map.Entry artifact : baselineMetadata.entrySet()) {
                        File baseLineFile = ((IP2Artifact)artifact.getValue()).getLocation();
                        String string = (String)artifact.getKey();
                        File reactorFile = reactorMetadata.get(string).getLocation();
                        if (baseLineFile.isFile() && baseLineFile.length() == 0L) {
                            this.log.error("baseline file " + baseLineFile.getAbsolutePath() + " is empty. Will not replace " + reactorFile);
                            continue;
                        }
                        FileUtils.copyFile((File)baseLineFile, (File)reactorFile);
                        result.put(string, (IP2Artifact)artifact.getValue());
                        if (string == null) continue;
                        replaced.add(string);
                    }
                    ArrayList<String> removed = new ArrayList<String>();
                    ArrayList<String> inconsistent = new ArrayList<String>();
                    for (Map.Entry entry : reactorMetadata.entrySet()) {
                        String classifier = (String)entry.getKey();
                        IP2Artifact artifact = (IP2Artifact)entry.getValue();
                        if (classifier == null || artifact == null) continue;
                        if (baselineReplace == BaselineReplace.all && !baselineMetadata.containsKey(classifier)) {
                            List attachedArtifacts = project.getAttachedArtifacts();
                            ListIterator iterator = attachedArtifacts.listIterator();
                            while (iterator.hasNext()) {
                                if (!classifier.equals(((Artifact)iterator.next()).getClassifier())) continue;
                                iterator.remove();
                                break;
                            }
                            artifact.getLocation().delete();
                            removed.add(classifier);
                            continue;
                        }
                        inconsistent.add(classifier);
                        result.put(classifier, artifact);
                    }
                    if (this.log.isInfoEnabled()) {
                        StringBuilder msg = new StringBuilder();
                        msg.append(project.toString());
                        msg.append("\n    The main artifact has been replaced with the baseline version.\n");
                        if (!replaced.isEmpty()) {
                            msg.append("    The following attached artifacts have been replaced with the baseline version: ");
                            msg.append(replaced.toString());
                            msg.append("\n");
                        }
                        if (!removed.isEmpty()) {
                            msg.append("    The following attached artifacts are not present in the baseline and have been removed: ");
                            msg.append(removed.toString());
                            msg.append("\n");
                        }
                        this.log.info(msg.toString());
                    }
                }
            } else {
                this.log.info("No baseline version " + project);
            }
        }
        return result;
    }

    private boolean isMissingOnlyDelta(ArtifactDelta delta) {
        if (delta instanceof MissingArtifactDelta) {
            return true;
        }
        if (delta instanceof CompoundArtifactDelta) {
            for (ArtifactDelta member : ((CompoundArtifactDelta)delta).getMembers().values()) {
                if (member instanceof MissingArtifactDelta) continue;
                return false;
            }
        }
        return true;
    }

    private CompoundArtifactDelta getDelta(BaselineService baselineService, Map<String, IP2Artifact> baselineMetadata, Map<String, IP2Artifact> generatedMetadata, MojoExecution execution) throws IOException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, IP2Artifact> classifierEntry : generatedMetadata.entrySet()) {
            String classifier = classifierEntry.getKey();
            if ("pack200".equals(classifier)) continue;
            String deltaKey = classifier != null ? "classifier-" + classifier : "no-classifier";
            IP2Artifact baselineArtifact = baselineMetadata.get(classifier);
            IP2Artifact reactorArtifact = classifierEntry.getValue();
            if (baselineArtifact == null) {
                result.put(deltaKey, new MissingArtifactDelta());
                continue;
            }
            if (!baselineService.isMetadataEqual(baselineArtifact, reactorArtifact)) {
                result.put(deltaKey, new SimpleArtifactDelta("p2 metadata different"));
                continue;
            }
            try {
                ArtifactDelta delta = this.zipComparator.getDelta(baselineArtifact.getLocation(), reactorArtifact.getLocation(), execution);
                if (delta == null) continue;
                result.put(deltaKey, delta);
            }
            catch (IOException e) {
                if (FileUtils.contentEquals((File)baselineArtifact.getLocation(), (File)reactorArtifact.getLocation())) continue;
                result.put(deltaKey, new SimpleArtifactDelta("different"));
            }
        }
        return !result.isEmpty() ? new CompoundArtifactDelta("baseline and build artifacts have same version but different contents", result) : null;
    }

    private <T> T getService(Class<T> type) {
        Object service = this.equinox.getService(type);
        if (service == null) {
            throw new IllegalStateException("Could not acquire service " + type);
        }
        return (T)service;
    }

    private static class MissingArtifactDelta
    implements ArtifactDelta {
        private MissingArtifactDelta() {
        }

        public String getMessage() {
            return "not present in baseline";
        }

        public String getDetailedMessage() {
            return this.getMessage();
        }
    }
}

