/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.sisu.equinox.launching.internal.P2ApplicationLauncher;

public abstract class AbstractP2MetadataMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.name}", required=true)
    protected String metadataRepositoryName;
    @Parameter(defaultValue="${project.build.directory}/site")
    protected File target;
    @Parameter(defaultValue="${project.name} Artifacts", required=true)
    protected String artifactRepositoryName;
    @Parameter(property="p2.timeout")
    private int forkedProcessTimeoutInSeconds;
    @Parameter
    private String argLine;
    @Parameter(defaultValue="true")
    protected boolean generateP2Metadata;
    @Parameter(defaultValue="true")
    private boolean compressRepository;
    @Component
    private P2ApplicationLauncher launcher;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.generateP2Metadata) {
            return;
        }
        try {
            if (this.getUpdateSiteLocation().isDirectory()) {
                this.generateMetadata();
            } else {
                this.logUpdateSiteLocationNotFound();
            }
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot generate P2 metadata", e);
        }
    }

    protected void logUpdateSiteLocationNotFound() {
        this.getLog().warn((CharSequence)(this.getUpdateSiteLocation().getAbsolutePath() + " does not exist or is not a directory"));
    }

    private void generateMetadata() throws Exception {
        int result;
        P2ApplicationLauncher launcher = this.launcher;
        launcher.setWorkingDirectory(this.project.getBasedir());
        launcher.setApplicationName(this.getPublisherApplication());
        this.addArguments(launcher);
        if (this.argLine != null && this.argLine.trim().length() > 0) {
            launcher.addArguments(new String[]{"-vmargs", this.argLine});
        }
        if ((result = launcher.execute(this.forkedProcessTimeoutInSeconds)) != 0) {
            throw new MojoFailureException("P2 publisher return code was " + result);
        }
    }

    protected void addArguments(P2ApplicationLauncher launcher) throws IOException, MalformedURLException {
        launcher.addArguments(new String[]{"-source", this.getUpdateSiteLocation().getAbsolutePath(), "-metadataRepository", this.getUpdateSiteLocation().toURL().toExternalForm(), "-metadataRepositoryName", this.metadataRepositoryName, "-artifactRepository", this.getUpdateSiteLocation().toURL().toExternalForm(), "-artifactRepositoryName", this.artifactRepositoryName, "-noDefaultIUs"});
        if (this.compressRepository) {
            launcher.addArguments(new String[]{"-compress"});
        }
    }

    protected abstract String getPublisherApplication();

    protected File getUpdateSiteLocation() {
        return this.target;
    }
}

