/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.resolver;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.ProjectDependenciesResolver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.BuildFailureException;
import org.eclipse.tycho.BuildProperties;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.IDependencyMetadata;
import org.eclipse.tycho.IllegalArtifactReferenceException;
import org.eclipse.tycho.MavenRepositoryLocation;
import org.eclipse.tycho.OptionalResolutionAction;
import org.eclipse.tycho.PackagingType;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.TychoConstants;
import org.eclipse.tycho.artifacts.DependencyArtifacts;
import org.eclipse.tycho.core.DependencyResolver;
import org.eclipse.tycho.core.DependencyResolverConfiguration;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.core.maven.MavenDependencyInjector;
import org.eclipse.tycho.core.osgitools.AbstractTychoProject;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.DebugUtils;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.targetplatform.ArtifactCollection;
import org.eclipse.tycho.core.osgitools.targetplatform.DefaultDependencyArtifacts;
import org.eclipse.tycho.core.osgitools.targetplatform.MultiEnvironmentDependencyArtifacts;
import org.eclipse.tycho.core.resolver.shared.PomDependencies;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.osgi.adapters.MavenLoggerAdapter;
import org.eclipse.tycho.p2.facade.internal.AttachedArtifact;
import org.eclipse.tycho.p2.metadata.DependencyMetadataGenerator;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.metadata.PublisherOptions;
import org.eclipse.tycho.p2.repository.LocalRepositoryP2Indices;
import org.eclipse.tycho.p2.resolver.P2MetadataProvider;
import org.eclipse.tycho.p2.resolver.PomDependencyProcessor;
import org.eclipse.tycho.p2.resolver.PomReactorProjectFacade;
import org.eclipse.tycho.p2.resolver.facade.P2ResolutionResult;
import org.eclipse.tycho.p2.resolver.facade.P2Resolver;
import org.eclipse.tycho.p2.resolver.facade.P2ResolverFactory;
import org.eclipse.tycho.p2.target.facade.PomDependencyCollector;
import org.eclipse.tycho.p2.target.facade.TargetDefinition;
import org.eclipse.tycho.p2.target.facade.TargetDefinitionFile;
import org.eclipse.tycho.p2.target.facade.TargetPlatformConfigurationStub;
import org.eclipse.tycho.p2maven.helper.PluginRealmHelper;
import org.eclipse.tycho.p2maven.repository.P2ArtifactRepositoryLayout;
import org.eclipse.tycho.repository.registry.facade.ReactorRepositoryManagerFacade;

@Component(role=DependencyResolver.class, hint="p2", instantiationStrategy="per-lookup")
public class P2DependencyResolver
extends AbstractLogEnabled
implements DependencyResolver,
Initializable {
    public static final String ROLE_HINT = "p2";
    @Requirement(hint="tycho-core")
    private EquinoxServiceFactory equinox;
    @Requirement
    private BundleReader bundleReader;
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private ProjectDependenciesResolver projectDependenciesResolver;
    @Requirement(role=TychoProject.class)
    private Map<String, TychoProject> projectTypes;
    @Requirement
    private PlexusContainer plexus;
    @Requirement
    private PluginRealmHelper pluginRealmHelper;
    @Requirement
    private LegacySupport context;
    private P2ResolverFactory resolverFactory;
    private DependencyMetadataGenerator generator;
    private ReactorRepositoryManagerFacade reactorRepositoryManager;

    public void setupProjects(MavenSession session, MavenProject project, ReactorProject reactorProject) {
        TargetPlatformConfiguration configuration = (TargetPlatformConfiguration)reactorProject.getContextValue(TychoConstants.CTX_TARGET_PLATFORM_CONFIGURATION);
        List environments = configuration.getEnvironments();
        Map<String, IDependencyMetadata> metadataMap = this.getDependencyMetadata(session, project, environments, OptionalResolutionAction.OPTIONAL);
        TreeMap<IDependencyMetadata.DependencyMetadataType, Set> typeMap = new TreeMap<IDependencyMetadata.DependencyMetadataType, Set>();
        for (IDependencyMetadata.DependencyMetadataType type : IDependencyMetadata.DependencyMetadataType.values()) {
            typeMap.put(type, new LinkedHashSet());
        }
        for (IDependencyMetadata metadata : metadataMap.values()) {
            typeMap.forEach((key, value) -> value.addAll(metadata.getDependencyMetadata(key)));
        }
        HashSet initial = new HashSet();
        typeMap.forEach((key, value) -> {
            reactorProject.setDependencyMetadata(key, (Collection)value);
            initial.addAll(value);
        });
        reactorProject.setDependencyMetadata(IDependencyMetadata.DependencyMetadataType.INITIAL, initial);
    }

    protected Map<String, IDependencyMetadata> getDependencyMetadata(MavenSession session, MavenProject project, List<TargetEnvironment> environments, OptionalResolutionAction optionalAction) {
        LinkedHashMap<String, IDependencyMetadata> metadata = new LinkedHashMap<String, IDependencyMetadata>();
        metadata.put(null, this.generator.generateMetadata((IArtifactFacade)new AttachedArtifact(project, project.getBasedir(), null), environments, optionalAction, new PublisherOptions()));
        try {
            this.pluginRealmHelper.execute(session, project, () -> {
                try {
                    for (P2MetadataProvider provider : this.plexus.lookupList(P2MetadataProvider.class)) {
                        Map<String, IDependencyMetadata> providedMetadata = provider.getDependencyMetadata(session, project, null, optionalAction);
                        if (providedMetadata == null) continue;
                        metadata.putAll(providedMetadata);
                    }
                }
                catch (ComponentLookupException componentLookupException) {
                    // empty catch block
                }
            }, this::isTychoP2Plugin);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return metadata;
    }

    protected boolean isTychoP2Plugin(PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor.getArtifactMap().containsKey("org.eclipse.tycho:tycho-p2-facade")) {
            return true;
        }
        for (ComponentDependency dependency : pluginDescriptor.getDependencies()) {
            if (!"org.eclipse.tycho".equals(dependency.getGroupId()) || !"tycho-p2-facade".equals(dependency.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    public TargetPlatform computePreliminaryTargetPlatform(MavenSession session, MavenProject project, List<ReactorProject> reactorProjects) {
        ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)project);
        TargetPlatformConfiguration configuration = TychoProjectUtils.getTargetPlatformConfiguration((ReactorProject)reactorProject);
        ExecutionEnvironmentConfiguration ee = TychoProjectUtils.getExecutionEnvironmentConfiguration((ReactorProject)reactorProject);
        TargetPlatformConfigurationStub tpConfiguration = new TargetPlatformConfigurationStub();
        for (ArtifactRepository repository : project.getRemoteArtifactRepositories()) {
            this.addEntireP2RepositoryToTargetPlatform(repository, tpConfiguration);
        }
        tpConfiguration.setEnvironments(configuration.getEnvironments());
        for (TargetDefinitionFile target : configuration.getTargets()) {
            tpConfiguration.addTargetDefinition((TargetDefinition)target);
        }
        tpConfiguration.addFilters(configuration.getFilters());
        tpConfiguration.setIncludeSourceMode(configuration.getTargetDefinitionIncludeSourceMode());
        return this.reactorRepositoryManager.computePreliminaryTargetPlatform(reactorProject, tpConfiguration, ee, reactorProjects);
    }

    private ReactorProject getThisReactorProject(MavenSession session, final MavenProject project, TargetPlatformConfiguration configuration) {
        List environments = configuration.getEnvironments();
        OptionalResolutionAction optionalAction = configuration.getDependencyResolverConfiguration().getOptionalResolutionAction();
        Map<String, IDependencyMetadata> dependencyMetadata = this.getDependencyMetadata(session, project, environments, optionalAction);
        final TreeMap<IDependencyMetadata.DependencyMetadataType, Set> typeMap = new TreeMap<IDependencyMetadata.DependencyMetadataType, Set>();
        for (IDependencyMetadata value : dependencyMetadata.values()) {
            for (IDependencyMetadata.DependencyMetadataType type : IDependencyMetadata.DependencyMetadataType.values()) {
                typeMap.computeIfAbsent(type, t -> new LinkedHashSet()).addAll(value.getDependencyMetadata(type));
            }
        }
        return new DefaultReactorProject(project){

            public Set<IInstallableUnit> getDependencyMetadata(IDependencyMetadata.DependencyMetadataType type) {
                return (Set)typeMap.get(type);
            }

            public Object getContextValue(String key) {
                Object value = super.getContextValue(key);
                if (value == null) {
                    return DefaultReactorProject.adapt((MavenProject)project).getContextValue(key);
                }
                return value;
            }

            public void setContextValue(String key, Object value) {
                super.setContextValue(key, value);
                DefaultReactorProject.adapt((MavenProject)project).setContextValue(key, value);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PomDependencyCollector resolvePomDependencies(MavenSession session, MavenProject project) {
        Object key2;
        ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)project);
        TargetPlatformConfiguration configuration = TychoProjectUtils.getTargetPlatformConfiguration((ReactorProject)reactorProject);
        PomDependencies pomDependencies = configuration.getPomDependencies();
        if (pomDependencies == PomDependencies.ignore) {
            return this.resolverFactory.newPomDependencyCollector(reactorProject);
        }
        List reactorProjects = DefaultReactorProject.adapt((MavenSession)session);
        HashMap<Object, ReactorProject> nonTychoReactorProjects = new HashMap<Object, ReactorProject>();
        HashSet<Object> projectIds = new HashSet<Object>();
        for (ReactorProject p : reactorProjects) {
            key2 = ArtifactUtils.key((String)p.getGroupId(), (String)p.getArtifactId(), (String)p.getVersion());
            projectIds.add(key2);
            String packaging = p.getPackaging();
            if (PackagingType.TYCHO_PACKAGING_TYPES.contains(packaging)) continue;
            nonTychoReactorProjects.put(key2, p);
        }
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("compile");
        key2 = P2DependencyResolver.class;
        synchronized (P2DependencyResolver.class) {
            String key3;
            Collection artifacts;
            try {
                artifacts = this.projectDependenciesResolver.resolve(project, scopes, session);
            }
            catch (MultipleArtifactsNotFoundException e) {
                HashSet missing = new HashSet(e.getMissingArtifacts());
                Iterator it = missing.iterator();
                while (it.hasNext()) {
                    Artifact a = (Artifact)it.next();
                    key3 = ArtifactUtils.key((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getBaseVersion());
                    if (!projectIds.contains(key3)) continue;
                    it.remove();
                }
                if (!missing.isEmpty()) {
                    throw new RuntimeException("Could not resolve project dependencies", e);
                }
                artifacts = e.getResolvedArtifacts();
                artifacts.removeAll(e.getMissingArtifacts());
            }
            catch (AbstractArtifactResolutionException e) {
                throw new RuntimeException("Could not resolve project dependencies", e);
            }
            ArrayList<Artifact> externalArtifacts = new ArrayList<Artifact>(artifacts.size());
            for (Artifact artifact : artifacts) {
                String key4 = ArtifactUtils.key((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getBaseVersion());
                if (projectIds.contains(key4)) continue;
                externalArtifacts.add(artifact);
            }
            PomDependencyProcessor pomDependencyProcessor = new PomDependencyProcessor(session, this.repositorySystem, this.resolverFactory, (LocalRepositoryP2Indices)this.equinox.getService(LocalRepositoryP2Indices.class), this.getLogger());
            PomDependencyCollector dependencyCollector = pomDependencyProcessor.collectPomDependencies(project, externalArtifacts, pomDependencies == PomDependencies.wrapAsBundle);
            for (Artifact artifact : artifacts) {
                key3 = ArtifactUtils.key((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getBaseVersion());
                if (!nonTychoReactorProjects.containsKey(key3)) continue;
                PomReactorProjectFacade projectFacade = new PomReactorProjectFacade(artifact, (ReactorProject)nonTychoReactorProjects.get(key3));
                dependencyCollector.addMavenArtifact((IArtifactFacade)projectFacade, pomDependencies == PomDependencies.wrapAsBundle);
            }
            DependencyArtifacts dependencyArtifacts = TychoProjectUtils.getDependencyArtifacts((ReactorProject)reactorProject);
            if (dependencyArtifacts instanceof ArtifactCollection) {
                ArtifactCollection collection = (ArtifactCollection)dependencyArtifacts;
                dependencyCollector.getMavenInstallableUnits().forEach((key, val) -> {
                    ArtifactKey artifactKey = dependencyCollector.getArtifactKey(val);
                    File location = val.getLocation();
                    try {
                        collection.addArtifactFile(artifactKey, location, Collections.singleton(key));
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                });
            }
            return dependencyCollector;
        }
    }

    private void addEntireP2RepositoryToTargetPlatform(ArtifactRepository repository, TargetPlatformConfigurationStub resolutionContext) {
        try {
            if (repository.getLayout() instanceof P2ArtifactRepositoryLayout) {
                URI url = new URL(repository.getUrl()).toURI();
                resolutionContext.addP2Repository(new MavenRepositoryLocation(repository.getId(), url));
                this.getLogger().debug("Added p2 repository " + repository.getId() + " (" + repository.getUrl() + ")");
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException("Invalid repository URL: " + repository.getUrl(), e);
        }
    }

    public DependencyArtifacts resolveDependencies(MavenSession session, MavenProject project, TargetPlatform targetPlatform, List<ReactorProject> reactorProjects, DependencyResolverConfiguration resolverConfiguration) {
        ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)project);
        if (targetPlatform == null) {
            targetPlatform = TychoProjectUtils.getTargetPlatform((ReactorProject)reactorProject);
        }
        TargetPlatformConfiguration configuration = TychoProjectUtils.getTargetPlatformConfiguration((ReactorProject)reactorProject);
        P2Resolver osgiResolverImpl = this.resolverFactory.createResolver((MavenLogger)new MavenLoggerAdapter(this.getLogger(), DebugUtils.isDebugEnabled((MavenSession)session, (MavenProject)project)));
        return this.doResolveDependencies(session, project, reactorProjects, resolverConfiguration, targetPlatform, osgiResolverImpl, configuration);
    }

    private DependencyArtifacts doResolveDependencies(MavenSession session, MavenProject project, List<ReactorProject> reactorProjects, DependencyResolverConfiguration resolverConfiguration, TargetPlatform targetPlatform, P2Resolver resolver, TargetPlatformConfiguration configuration) {
        HashMap<File, ReactorProject> projects = new HashMap<File, ReactorProject>();
        resolver.setEnvironments(configuration.getEnvironments());
        resolver.setAdditionalFilterProperties(configuration.getProfileProperties());
        resolver.setPomDependencies(configuration.getPomDependencies());
        for (ReactorProject otherProject : reactorProjects) {
            projects.put(otherProject.getBasedir(), otherProject);
        }
        if (resolverConfiguration != null) {
            for (ArtifactKey dependency : resolverConfiguration.getExtraRequirements()) {
                try {
                    resolver.addDependency(dependency.getType(), dependency.getId(), dependency.getVersion());
                }
                catch (IllegalArtifactReferenceException e) {
                    throw new BuildFailureException("Invalid extraRequirement " + dependency.getType() + ":" + dependency.getId() + ":" + dependency.getVersion() + ": " + e.getMessage(), (Throwable)e);
                }
            }
        }
        BuildProperties buildProperties = DefaultReactorProject.adapt((MavenProject)project).getBuildProperties();
        Collection additionalBundles = buildProperties.getAdditionalBundles();
        for (String additionalBundle : additionalBundles) {
            resolver.addAdditionalBundleDependency(additionalBundle);
        }
        ReactorProject optionalDependencyPreparedProject = this.getThisReactorProject(session, project, configuration);
        if (!this.isAllowConflictingDependencies(project, configuration)) {
            Map results = resolver.resolveTargetDependencies(targetPlatform, optionalDependencyPreparedProject);
            MultiEnvironmentDependencyArtifacts multiPlatform = new MultiEnvironmentDependencyArtifacts(DefaultReactorProject.adapt((MavenProject)project));
            for (Map.Entry entry : results.entrySet()) {
                TargetEnvironment environment = (TargetEnvironment)entry.getKey();
                P2ResolutionResult result = (P2ResolutionResult)entry.getValue();
                DefaultDependencyArtifacts platform = this.newDefaultTargetPlatform(DefaultReactorProject.adapt((MavenProject)project), projects, result);
                multiPlatform.addPlatform(environment, platform);
            }
            return multiPlatform;
        }
        P2ResolutionResult result = resolver.collectProjectDependencies(targetPlatform, optionalDependencyPreparedProject);
        return this.newDefaultTargetPlatform(DefaultReactorProject.adapt((MavenProject)project), projects, result);
    }

    private boolean isAllowConflictingDependencies(MavenProject project, TargetPlatformConfiguration configuration) {
        Boolean allow;
        String packaging = project.getPackaging();
        if ("eclipse-feature".equals(packaging) && (allow = configuration.getAllowConflictingDependencies()) != null) {
            return allow;
        }
        return false;
    }

    protected DefaultDependencyArtifacts newDefaultTargetPlatform(ReactorProject project, Map<File, ReactorProject> projects, P2ResolutionResult result) {
        DefaultArtifactKey key;
        DefaultDependencyArtifacts platform = new DefaultDependencyArtifacts(project);
        platform.addNonReactorUnits(result.getNonReactorUnits());
        for (P2ResolutionResult.Entry entry : result.getArtifacts()) {
            key = new DefaultArtifactKey(entry.getType(), entry.getId(), entry.getVersion());
            ReactorProject otherProject = null;
            File location = entry.getLocation(false);
            if (location != null) {
                otherProject = projects.get(location);
            }
            if (otherProject != null) {
                platform.addReactorArtifact((ArtifactKey)key, otherProject, entry.getClassifier(), entry.getInstallableUnits());
                continue;
            }
            platform.addArtifactFile((ArtifactKey)key, () -> entry.getLocation(true), entry.getInstallableUnits());
        }
        for (P2ResolutionResult.Entry entry : result.getDependencyFragments()) {
            key = new DefaultArtifactKey(entry.getType(), entry.getId(), entry.getVersion());
            platform.addFragment((ArtifactKey)key, () -> entry.getLocation(true), entry.getInstallableUnits());
        }
        return platform;
    }

    public void initialize() throws InitializationException {
        this.resolverFactory = Objects.requireNonNull((P2ResolverFactory)this.equinox.getService(P2ResolverFactory.class), "P2ResolverFactory service is missing");
        this.generator = Objects.requireNonNull((DependencyMetadataGenerator)this.equinox.getService(DependencyMetadataGenerator.class, "(role-hint=dependency-only)"), "DependencyMetadataGenerator(role-hint=dependency-only) is missing");
        this.reactorRepositoryManager = Objects.requireNonNull((ReactorRepositoryManagerFacade)this.equinox.getService(ReactorRepositoryManagerFacade.class), "ReactorRepositoryManagerFacade service is missing");
    }

    public void injectDependenciesIntoMavenModel(MavenProject project, AbstractTychoProject projectType, DependencyArtifacts dependencyArtifacts, DependencyArtifacts testDependencyArtifacts, Logger logger) {
        MavenDependencyInjector.injectMavenDependencies((MavenProject)project, (DependencyArtifacts)dependencyArtifacts, (DependencyArtifacts)testDependencyArtifacts, (BundleReader)this.bundleReader, arg_0 -> ((P2ResolverFactory)this.resolverFactory).resolveDependencyDescriptor(arg_0), (Logger)logger, (RepositorySystem)this.repositorySystem, (Settings)this.context.getSession().getSettings());
    }
}

