/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.model;

import de.pdark.decentxml.Element;
import java.util.Objects;

public class PluginRef {
    private final Element dom;

    public int hashCode() {
        return Objects.hash(this.getId(), this.getVersion());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof PluginRef)) return false;
        PluginRef other = (PluginRef)obj;
        if (!Objects.equals(this.getId(), other.getId())) return false;
        if (!Objects.equals(this.getVersion(), other.getVersion())) return false;
        return true;
    }

    public String toString() {
        return this.getId() + "_" + this.getVersion();
    }

    public PluginRef(Element dom) {
        this.dom = dom;
    }

    public PluginRef(String name) {
        this.dom = new Element(name);
    }

    public String getId() {
        return this.dom.getAttributeValue("id");
    }

    public void setId(String id) {
        this.dom.setAttribute("id", id);
    }

    public String getVersion() {
        return this.dom.getAttributeValue("version");
    }

    public void setVersion(String version) {
        this.dom.setAttribute("version", version);
    }

    public String getOs() {
        return this.dom.getAttributeValue("os");
    }

    public void setOs(String os) {
        this.dom.setAttribute("os", os);
    }

    public String getWs() {
        return this.dom.getAttributeValue("ws");
    }

    public void setWs(String ws) {
        this.dom.setAttribute("ws", ws);
    }

    public String getArch() {
        return this.dom.getAttributeValue("arch");
    }

    public void setArch(String arch) {
        this.dom.setAttribute("arch", arch);
    }

    public void removeAttribute(String attributeName) {
        this.dom.removeAttribute(attributeName);
    }

    Element getDom() {
        return this.dom;
    }
}

