/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class Platform {
    final Xpp3Dom dom;

    public Platform(Xpp3Dom dom) {
        this.dom = dom;
    }

    public Platform(Platform other) {
        this.dom = new Xpp3Dom(other.dom);
        this.setTimestamp(System.currentTimeMillis());
    }

    public Platform() {
        this.dom = new Xpp3Dom("config");
        this.dom.setAttribute("version", "3.0");
        this.setTimestamp(System.currentTimeMillis());
        this.setTransient(true);
    }

    public void setTimestamp(long timestamp) {
        this.dom.setAttribute("date", Long.toString(timestamp));
    }

    public static Platform read(File file) throws IOException, XmlPullParserException {
        try (XmlStreamReader reader = ReaderFactory.newXmlReader((File)file);){
            Platform platform = new Platform(Xpp3DomBuilder.build((Reader)reader));
            return platform;
        }
    }

    public static void write(Platform platform, File file) throws IOException {
        file.getParentFile().mkdirs();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            Xpp3DomWriter.write((Writer)writer, (Xpp3Dom)platform.dom);
        }
    }

    public boolean isTransient() {
        return Boolean.parseBoolean(this.dom.getAttribute("transient"));
    }

    public void setTransient(boolean value) {
        this.dom.setAttribute("transient", value ? "true" : "false");
    }

    public List<Site> getSites() {
        ArrayList<Site> sites = new ArrayList<Site>();
        for (Xpp3Dom siteDom : this.dom.getChildren("site")) {
            sites.add(new Site(siteDom));
        }
        return Collections.unmodifiableList(sites);
    }

    public void addSite(Site site) {
        this.dom.addChild(site.dom);
    }

    public static class Feature {
        private final Xpp3Dom dom;

        public Feature(Xpp3Dom dom) {
            this.dom = dom;
        }

        public Feature() {
            this.dom = new Xpp3Dom("feature");
        }

        public void setId(String value) {
            this.dom.setAttribute("id", value);
        }

        public String getId() {
            return this.dom.getAttribute("id");
        }

        public void setVersion(String value) {
            this.dom.setAttribute("version", value);
        }

        public String getVersion() {
            return this.dom.getAttribute("version");
        }

        public void setUrl(String value) {
            this.dom.setAttribute("url", value);
        }

        public String getUrl() {
            return this.dom.getAttribute("url");
        }
    }

    public static class Site {
        final Xpp3Dom dom;

        public Site(Xpp3Dom dom) {
            this.dom = dom;
        }

        public Site(String url) {
            this.dom = new Xpp3Dom("site");
            this.dom.setAttribute("url", url);
            this.dom.setAttribute("enabled", "true");
            this.dom.setAttribute("updateable", "true");
            this.dom.setAttribute("policy", "USER-INCLUDE");
        }

        public List<Feature> getFeatures() {
            ArrayList<Feature> features = new ArrayList<Feature>();
            for (Xpp3Dom featureDom : this.dom.getChildren("feature")) {
                features.add(new Feature(featureDom));
            }
            return Collections.unmodifiableList(features);
        }

        public List<String> getPlugins() {
            ArrayList<String> plugins = new ArrayList<String>();
            String pluginsStr = this.getPluginsStr();
            if (pluginsStr != null) {
                StringTokenizer st = new StringTokenizer(pluginsStr, ",");
                while (st.hasMoreTokens()) {
                    plugins.add(st.nextToken());
                }
            }
            return Collections.unmodifiableList(plugins);
        }

        public void setPlugins(List<String> plugins) {
            this.setPluginsStr(String.join((CharSequence)",", plugins));
        }

        public String getPluginsStr() {
            return this.dom.getAttribute("list");
        }

        public void setPluginsStr(String plugins) {
            this.dom.setAttribute("list", plugins);
        }

        public void setFeatures(List<Feature> features) {
            int i = 0;
            while (i < this.dom.getChildCount()) {
                if ("feature".equals(this.dom.getChild(i).getName())) {
                    this.dom.removeChild(i);
                    continue;
                }
                ++i;
            }
            if (features != null) {
                for (Feature feature : features) {
                    this.dom.addChild(feature.dom);
                }
            }
        }
    }
}

