/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.model;

import de.pdark.decentxml.Attribute;
import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.XMLIOSource;
import de.pdark.decentxml.XMLParser;
import de.pdark.decentxml.XMLSource;
import de.pdark.decentxml.XMLWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.tycho.model.BundleConfiguration;
import org.eclipse.tycho.model.FeatureRef;
import org.eclipse.tycho.model.Launcher;
import org.eclipse.tycho.model.ModelFileSyntaxException;
import org.eclipse.tycho.model.PluginRef;

public class ProductConfiguration {
    private static final XMLParser parser = new XMLParser();
    private Element dom;
    private Document document;

    public static ProductConfiguration read(File file) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        return ProductConfiguration.read(is);
    }

    public static ProductConfiguration read(InputStream input) throws IOException {
        try {
            ProductConfiguration productConfiguration = new ProductConfiguration(parser.parse((XMLSource)new XMLIOSource(input)));
            return productConfiguration;
        }
        finally {
            IOUtil.close((InputStream)input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(ProductConfiguration product, File file) throws IOException {
        Document document = product.document;
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            String enc = document.getEncoding() != null ? document.getEncoding() : "UTF-8";
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, enc);
            XMLWriter xw = new XMLWriter((Writer)w);
            try {
                document.toXML(xw);
            }
            finally {
                xw.flush();
            }
        }
    }

    public ProductConfiguration(Document document) {
        this.document = document;
        this.dom = document.getRootElement();
    }

    public String getProduct() {
        return this.dom.getAttributeValue("id");
    }

    public String getApplication() {
        return this.dom.getAttributeValue("application");
    }

    public List<FeatureRef> getFeatures() throws ModelFileSyntaxException {
        Element featuresDom = this.dom.getChild("features");
        if (featuresDom == null) {
            return Collections.emptyList();
        }
        ArrayList<FeatureRef> features = new ArrayList<FeatureRef>();
        for (Element featureDom : featuresDom.getChildren()) {
            features.add(ProductConfiguration.parseFeature(featureDom));
        }
        return Collections.unmodifiableList(features);
    }

    private static FeatureRef parseFeature(Element featureDom) throws ModelFileSyntaxException {
        if (!"feature".equals(featureDom.getName())) {
            throw new ModelFileSyntaxException("Invalid child element \"" + featureDom.getName() + "\" in \"features\"");
        }
        return new FeatureRef(featureDom);
    }

    public void removeRootInstalledFeatures() {
        Element featuresDom = this.dom.getChild("features");
        if (featuresDom != null) {
            for (int childIx = featuresDom.getNodes().size() - 1; childIx > 0; --childIx) {
                Element elementDom;
                Node nodeDom = featuresDom.getNode(childIx);
                if (!(nodeDom instanceof Element) || ProductConfiguration.parseFeature(elementDom = (Element)nodeDom).getInstallMode() != FeatureRef.InstallMode.root) continue;
                featuresDom.removeNode(childIx);
            }
        }
    }

    public String getId() {
        return this.dom.getAttributeValue("uid");
    }

    public Launcher getLauncher() {
        Element domLauncher = this.dom.getChild("launcher");
        if (domLauncher == null) {
            return null;
        }
        return new Launcher(domLauncher);
    }

    public String getName() {
        return this.dom.getAttributeValue("name");
    }

    public List<PluginRef> getPlugins() {
        Element pluginsDom = this.dom.getChild("plugins");
        if (pluginsDom == null) {
            return Collections.emptyList();
        }
        ArrayList<PluginRef> plugins = new ArrayList<PluginRef>();
        for (Element pluginDom : pluginsDom.getChildren("plugin")) {
            plugins.add(new PluginRef(pluginDom));
        }
        return Collections.unmodifiableList(plugins);
    }

    public boolean useFeatures() {
        return Boolean.parseBoolean(this.dom.getAttributeValue("useFeatures"));
    }

    public boolean includeLaunchers() {
        String attribute = this.dom.getAttributeValue("includeLaunchers");
        return attribute == null ? true : Boolean.parseBoolean(attribute);
    }

    public String getVersion() {
        return this.dom.getAttributeValue("version");
    }

    public void setVersion(String version) {
        this.dom.setAttribute("version", version);
    }

    public List<String> getW32Icons() {
        Element domLauncher = this.dom.getChild("launcher");
        if (domLauncher == null) {
            return null;
        }
        Element win = domLauncher.getChild("win");
        if (win == null) {
            return null;
        }
        ArrayList<String> icons = new ArrayList<String>();
        String useIco = win.getAttributeValue("useIco");
        if (Boolean.valueOf(useIco).booleanValue()) {
            Element ico = win.getChild("ico");
            icons.add(ico.getAttributeValue("path"));
        } else {
            for (Element bmp : win.getChildren("bmp")) {
                List attibuteNames = bmp.getAttributes();
                if (attibuteNames == null || attibuteNames.size() <= 0) continue;
                icons.add(((Attribute)attibuteNames.get(0)).getValue());
            }
        }
        return icons;
    }

    public String getLinuxIcon() {
        Element domLauncher = this.dom.getChild("launcher");
        if (domLauncher == null) {
            return null;
        }
        Element linux = domLauncher.getChild("linux");
        if (linux == null) {
            return null;
        }
        return linux.getAttributeValue("icon");
    }

    public String getFreeBSDIcon() {
        Element domLauncher = this.dom.getChild("launcher");
        if (domLauncher == null) {
            return null;
        }
        Element freebsd = domLauncher.getChild("freebsd");
        if (freebsd == null) {
            return null;
        }
        return freebsd.getAttributeValue("icon");
    }

    public Map<String, BundleConfiguration> getPluginConfiguration() {
        Element configurationsDom = this.dom.getChild("configurations");
        if (configurationsDom == null) {
            return null;
        }
        HashMap<String, BundleConfiguration> configs = new HashMap<String, BundleConfiguration>();
        for (Element pluginDom : configurationsDom.getChildren("plugin")) {
            configs.put(pluginDom.getAttributeValue("id"), new BundleConfiguration(pluginDom));
        }
        return Collections.unmodifiableMap(configs);
    }

    public List<ConfigurationProperty> getConfigurationProperties() {
        Element configurationsDom = this.dom.getChild("configurations");
        if (configurationsDom == null) {
            return null;
        }
        List propertyDoms = configurationsDom.getChildren("property");
        if (propertyDoms == null) {
            return null;
        }
        ArrayList<ConfigurationProperty> properties = new ArrayList<ConfigurationProperty>();
        for (Element properyDom : propertyDoms) {
            properties.add(new ConfigurationProperty(properyDom));
        }
        return Collections.unmodifiableList(properties);
    }

    public String getMacIcon() {
        Element domLauncher = this.dom.getChild("launcher");
        if (domLauncher == null) {
            return null;
        }
        Element linux = domLauncher.getChild("macosx");
        if (linux == null) {
            return null;
        }
        return linux.getAttributeValue("icon");
    }

    public ConfigIni getConfigIni() {
        Element configIniElement = this.dom.getChild("configIni");
        if (configIniElement == null) {
            return null;
        }
        return new ConfigIni(configIniElement);
    }

    public static class ConfigurationProperty {
        private final Element dom;

        public ConfigurationProperty(Element dom) {
            this.dom = dom;
        }

        public String getName() {
            return this.dom.getAttributeValue("name");
        }

        public String getValue() {
            return this.dom.getAttributeValue("value");
        }

        public void setValue(String value) {
            this.dom.setAttribute("value", value);
        }
    }

    public static class ConfigIni {
        private String linuxConfigIni;
        private String freebsdConfigIni;
        private String macosxConfigIni;
        private String solarisConfigIni;
        private String win32ConfigIni;
        private boolean useDefault = true;

        private ConfigIni(Element configIniElement) {
            this.useDefault = "default".equals(configIniElement.getAttributeValue("use"));
            this.linuxConfigIni = this.getOsSpecificConfigIni(configIniElement, "linux");
            this.freebsdConfigIni = this.getOsSpecificConfigIni(configIniElement, "freebsd");
            this.macosxConfigIni = this.getOsSpecificConfigIni(configIniElement, "macosx");
            this.solarisConfigIni = this.getOsSpecificConfigIni(configIniElement, "solaris");
            this.win32ConfigIni = this.getOsSpecificConfigIni(configIniElement, "win32");
        }

        public boolean isUseDefault() {
            return this.useDefault;
        }

        private String getOsSpecificConfigIni(Element configIniElement, String os) {
            String trimmedValue;
            Element osElement = configIniElement.getChild(os);
            if (osElement != null && (trimmedValue = osElement.getTrimmedText()).length() > 0) {
                return trimmedValue;
            }
            return null;
        }

        public String getLinuxConfigIni() {
            return this.linuxConfigIni;
        }

        public String getFreeBSDConfigIni() {
            return this.freebsdConfigIni;
        }

        public String getMacosxConfigIni() {
            return this.macosxConfigIni;
        }

        public String getSolarisConfigIni() {
            return this.solarisConfigIni;
        }

        public String getWin32ConfigIni() {
            return this.win32ConfigIni;
        }
    }
}

