/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.model;

import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.XMLIOSource;
import de.pdark.decentxml.XMLParser;
import de.pdark.decentxml.XMLSource;
import de.pdark.decentxml.XMLWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.tycho.model.PluginRef;
import org.eclipse.tycho.model.RepositoryReference;
import org.eclipse.tycho.model.UpdateSite;

public class Category {
    public static final String CATEGORY_XML = "category.xml";
    private static XMLParser parser = new XMLParser();
    private final Element dom;
    private final Document document;

    public Category(Document document) {
        this.document = document;
        this.dom = document.getRootElement();
    }

    public List<UpdateSite.SiteFeatureRef> getFeatures() {
        ArrayList<UpdateSite.SiteFeatureRef> features = new ArrayList<UpdateSite.SiteFeatureRef>();
        for (Element featureDom : this.dom.getChildren("feature")) {
            features.add(new UpdateSite.SiteFeatureRef(featureDom));
        }
        return Collections.unmodifiableList(features);
    }

    public List<PluginRef> getPlugins() {
        ArrayList<PluginRef> plugins = new ArrayList<PluginRef>();
        for (Element pluginDom : this.dom.getChildren("bundle")) {
            plugins.add(new PluginRef(pluginDom));
        }
        return Collections.unmodifiableList(plugins);
    }

    public List<RepositoryReference> getRepositoryReferences() {
        ArrayList<RepositoryReference> repos = new ArrayList<RepositoryReference>();
        for (Element repoDom : this.dom.getChildren("repository-reference")) {
            repos.add(new RepositoryReference(repoDom));
        }
        return Collections.unmodifiableList(repos);
    }

    public static Category read(File file) throws IOException {
        return Category.read(new BufferedInputStream(new FileInputStream(file)));
    }

    public static Category read(InputStream is) throws IOException {
        try {
            Category category = new Category(parser.parse((XMLSource)new XMLIOSource(is)));
            return category;
        }
        finally {
            IOUtil.close((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Category category, File file) throws IOException {
        Document document = category.document;
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            String enc = document.getEncoding() != null ? document.getEncoding() : "UTF-8";
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, enc);
            XMLWriter xw = new XMLWriter((Writer)w);
            try {
                document.toXML(xw);
            }
            finally {
                xw.flush();
            }
        }
    }
}

