/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.model;

import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.XMLIOSource;
import de.pdark.decentxml.XMLParser;
import de.pdark.decentxml.XMLSource;
import de.pdark.decentxml.XMLWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.tycho.model.FeatureRef;

public class UpdateSite {
    public static final String SITE_XML = "site.xml";
    private static XMLParser parser = new XMLParser();
    private final Element dom;
    private final Document document;
    private String associateSitesUrl;

    public UpdateSite(Document document) {
        this.document = document;
        this.dom = document.getRootElement();
        if (this.dom.getAttribute("associateSitesURL") != null) {
            this.associateSitesUrl = this.dom.getAttributeValue("associateSitesURL");
        }
    }

    public List<SiteFeatureRef> getFeatures() {
        ArrayList<SiteFeatureRef> features = new ArrayList<SiteFeatureRef>();
        for (Element featureDom : this.dom.getChildren("feature")) {
            features.add(new SiteFeatureRef(featureDom));
        }
        return Collections.unmodifiableList(features);
    }

    public Map<String, String> getArchives() {
        HashMap<String, String> archives = new HashMap<String, String>();
        for (Element archiveDom : this.dom.getChildren("archive")) {
            String path = archiveDom.getAttributeValue("path");
            String url = archiveDom.getAttributeValue("url");
            archives.put(path, url);
        }
        return Collections.unmodifiableMap(archives);
    }

    public void removeArchives() {
        for (Element archive : this.dom.getChildren("archive")) {
            this.dom.removeNode((Node)archive);
        }
    }

    public static UpdateSite read(File file) throws IOException {
        return UpdateSite.read(new BufferedInputStream(new FileInputStream(file)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpdateSite read(InputStream is) throws IOException {
        try {
            UpdateSite updateSite = new UpdateSite(parser.parse((XMLSource)new XMLIOSource(is)));
            return updateSite;
        }
        finally {
            IOUtil.close((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(UpdateSite site, File file) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        Document document = site.document;
        try {
            String enc = document.getEncoding() != null ? document.getEncoding() : "UTF-8";
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, enc);
            XMLWriter xw = new XMLWriter((Writer)w);
            try {
                document.toXML(xw);
            }
            finally {
                xw.flush();
            }
        }
        finally {
            IOUtil.close((OutputStream)os);
        }
    }

    public boolean isPack200() {
        String pack200 = this.dom.getAttributeValue("pack200");
        return "true".equals(pack200);
    }

    public String getAssociateSitesUrl() {
        return this.associateSitesUrl;
    }

    public static class SiteFeatureRef
    extends FeatureRef {
        public SiteFeatureRef(Element dom) {
            super(dom);
        }

        public void setUrl(String url) {
            this.dom.setAttribute("url", url);
        }

        public String getUrl() {
            return this.dom.getAttributeValue("url");
        }
    }
}

