/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.bndlib;

import aQute.bnd.osgi.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class PathResource
implements Resource {
    private String extra;
    private Path path;

    public PathResource(Path path) {
        this.path = path;
    }

    public void close() throws IOException {
    }

    public InputStream openInputStream() throws Exception {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    public void write(OutputStream out) throws Exception {
        try (InputStream stream = this.openInputStream();){
            stream.transferTo(out);
        }
    }

    public long lastModified() {
        try {
            return Files.getLastModifiedTime(this.path, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public String getExtra() {
        return this.extra;
    }

    public long size() throws Exception {
        return Files.size(this.path);
    }

    public synchronized ByteBuffer buffer() throws Exception {
        try (InputStream stream = this.openInputStream();){
            ByteBuffer byteBuffer = ByteBuffer.wrap(stream.readAllBytes());
            return byteBuffer;
        }
    }
}

