/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.bndlib;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.service.AnalyzerPlugin;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.eclipse.tycho.bndlib.SourceCodeAnalyzer;
import org.eclipse.tycho.bndlib.source.SourceCodeResolver;

public class SourceCodeAnalyzerPlugin
implements AnalyzerPlugin {
    private List<Path> sourcePaths;
    private boolean alreadyRun;
    private SourceCodeAnalyzer codeAnalyzer;

    public SourceCodeAnalyzerPlugin() {
        this(null);
    }

    public SourceCodeAnalyzerPlugin(List<Path> sourcePaths) {
        this.sourcePaths = sourcePaths;
    }

    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        if (this.alreadyRun) {
            return false;
        }
        this.alreadyRun = true;
        List<Path> sourcePathList = this.getSourcePath(analyzer);
        this.codeAnalyzer = new SourceCodeAnalyzer(analyzer, new SourceCodeResolver(sourcePathList));
        for (Path sourcePath : sourcePathList) {
            Files.walkFileTree(sourcePath, this.codeAnalyzer);
        }
        return false;
    }

    private List<Path> getSourcePath(Analyzer analyzer) {
        if (this.sourcePaths != null) {
            return this.sourcePaths;
        }
        if (analyzer instanceof Builder) {
            Builder builder = (Builder)analyzer;
            return builder.getSourcePath().stream().map(File::toPath).toList();
        }
        return List.of();
    }

    public Clazz getPackageInfoClass(Descriptors.PackageRef packageRef) {
        if (this.codeAnalyzer == null) {
            return null;
        }
        return this.codeAnalyzer.packageInfoMap.get(packageRef);
    }
}

