/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.transport;

import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.eclipse.tycho.IRepositoryIdManager;
import org.eclipse.tycho.MavenRepositoryLocation;
import org.eclipse.tycho.MavenRepositorySettings;
import org.eclipse.tycho.p2maven.helper.ProxyHelper;
import org.eclipse.tycho.p2maven.repository.P2ArtifactRepositoryLayout;

@Component(role=MavenAuthenticator.class)
public class MavenAuthenticator
extends Authenticator
implements Initializable {
    private static final Comparator<URI> LONGEST_PREFIX_MATCH = (loc1, loc2) -> {
        String s1 = loc1.normalize().toASCIIString();
        String s2 = loc2.normalize().toASCIIString();
        return Long.compare(s2.length(), s1.length());
    };
    static final String PROXY_AUTHORIZATION_HEADER = "Proxy-Authorization";
    static final String AUTHORIZATION_HEADER = "Authorization";
    private static final ThreadLocal<Stack<URI>> locationStack = ThreadLocal.withInitial(Stack::new);
    private static final Map<URI, List<URI>> repositoryChain = new ConcurrentHashMap<URI, List<URI>>();
    @Requirement
    LegacySupport legacySupport;
    @Requirement
    ProxyHelper proxyHelper;
    @Requirement
    IRepositoryIdManager repositoryIdManager;
    @Requirement
    MavenRepositorySettings mavenRepositorySettings;
    @Requirement
    Logger log;
    private List<MavenRepositoryLocation> repositoryLocations;

    public MavenRepositorySettings.Credentials getServerCredentials(URI requestUri) {
        Stream<URI> repoStream;
        Stack<URI> stack = locationStack.get();
        if (stack.isEmpty()) {
            repoStream = this.getLongestPrefixStream(requestUri);
        } else {
            ArrayList<URI> list = new ArrayList<URI>(stack);
            Collections.reverse(list);
            repoStream = list.stream();
        }
        List<MavenRepositoryLocation> locations = this.getMavenLocations();
        return Stream.concat(Stream.of(requestUri), repoStream.takeWhile(repo -> Objects.equals(repo.getHost(), requestUri.getHost()))).flatMap(uri -> {
            this.log.debug("Fetching credentials for " + String.valueOf(uri));
            return locations.stream().filter(loc -> this.uriPrefixMatch((URI)uri, loc.getURL()));
        }).map(arg_0 -> ((MavenRepositorySettings)this.mavenRepositorySettings).getCredentials(arg_0)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private boolean uriPrefixMatch(URI matchUri, URI prefixUri) {
        String prefix = prefixUri.normalize().toASCIIString();
        String match = matchUri.normalize().toASCIIString();
        if (match.startsWith(prefix)) {
            this.log.debug("Found matching " + String.valueOf(prefixUri) + " for " + String.valueOf(matchUri));
            return true;
        }
        this.log.debug(String.valueOf(prefixUri) + " does not match (prefix = " + prefix + ", to match = " + match + ")");
        return false;
    }

    private Stream<URI> getLongestPrefixStream(URI requestUri) {
        List list = repositoryChain.entrySet().stream().filter(entry -> this.uriPrefixMatch(requestUri, (URI)entry.getKey())).sorted(Comparator.comparing(Map.Entry::getKey, LONGEST_PREFIX_MATCH)).flatMap(entry -> ((List)entry.getValue()).stream()).toList();
        return list.stream();
    }

    private List<MavenRepositoryLocation> getMavenLocations() {
        Stream locations = this.repositoryLocations.stream();
        locations = Stream.concat(locations, this.repositoryIdManager.getKnownMavenRepositoryLocations());
        List<MavenRepositoryLocation> sorted = locations.sorted(Comparator.comparing(MavenRepositoryLocation::getURL, LONGEST_PREFIX_MATCH)).toList();
        return sorted;
    }

    public Authenticator preemtiveAuth(BiConsumer<String, String> headerConsumer, URI uri) {
        final PasswordAuthentication proxyAuth = this.getAuth(Authenticator.RequestorType.PROXY, uri);
        final PasswordAuthentication serverAuth = this.getAuth(Authenticator.RequestorType.SERVER, uri);
        this.addAuthHeader(headerConsumer, proxyAuth, PROXY_AUTHORIZATION_HEADER);
        this.addAuthHeader(headerConsumer, serverAuth, AUTHORIZATION_HEADER);
        return new Authenticator(this){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                Authenticator.RequestorType type = this.getRequestorType();
                if (type == Authenticator.RequestorType.PROXY) {
                    return proxyAuth;
                }
                if (type == Authenticator.RequestorType.SERVER) {
                    return serverAuth;
                }
                return null;
            }
        };
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        try {
            return this.getAuth(this.getRequestorType(), this.getRequestingURL().toURI());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private PasswordAuthentication getAuth(Authenticator.RequestorType type, URI uri) {
        String userName;
        MavenRepositorySettings.Credentials credentials;
        if (type == Authenticator.RequestorType.PROXY) {
            return this.proxyHelper.getPasswordAuthentication(uri, type);
        }
        if (type == Authenticator.RequestorType.SERVER && (credentials = this.getServerCredentials(uri)) != null && (userName = credentials.getUserName()) != null) {
            String password = credentials.getPassword();
            return new PasswordAuthentication(userName, password == null ? new char[]{} : password.toCharArray());
        }
        return null;
    }

    private void addAuthHeader(BiConsumer<String, String> headerConsumer, PasswordAuthentication authentication, String header) {
        if (authentication == null) {
            return;
        }
        String encoding = Base64.getEncoder().encodeToString((authentication.getUserName() + ":" + new String(authentication.getPassword())).getBytes());
        headerConsumer.accept(header, "Basic " + encoding);
    }

    public void initialize() throws InitializationException {
        MavenSession session = this.legacySupport.getSession();
        if (session == null) {
            this.repositoryLocations = List.of();
        } else {
            List projects = Objects.requireNonNullElse(session.getProjects(), Collections.emptyList());
            this.repositoryLocations = projects.stream().map(MavenProject::getRemoteArtifactRepositories).flatMap(Collection::stream).filter(r -> r.getLayout() instanceof P2ArtifactRepositoryLayout).map(r -> {
                try {
                    return new MavenRepositoryLocation(r.getId(), new URL(r.getUrl()).toURI());
                }
                catch (MalformedURLException | URISyntaxException e) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
        }
    }

    public void enterLoad(URI location) {
        this.log.debug("Enter loading repository " + String.valueOf(location));
        Stack<URI> stack = locationStack.get();
        if (!stack.isEmpty()) {
            ArrayList list = new ArrayList(locationStack.get());
            Collections.reverse(list);
            repositoryChain.putIfAbsent(location.normalize(), list);
        }
        stack.push(location);
    }

    public void exitLoad() {
        URI pop = locationStack.get().pop();
        this.log.debug("Exit loading repository " + String.valueOf(pop));
    }
}

