/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.advices;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.actions.IPropertyAdvice;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;

public class MavenPropertiesAdvice
implements IPropertyAdvice {
    private final Map<String, String> properties = new LinkedHashMap<String, String>();

    public MavenPropertiesAdvice(Map<String, String> properties) {
        this.properties.putAll(properties);
    }

    public MavenPropertiesAdvice(String groupId, String artifactId, String version) {
        this.properties.put("maven-groupId", groupId);
        this.properties.put("maven-artifactId", artifactId);
        this.properties.put("maven-version", version);
    }

    public MavenPropertiesAdvice(String groupId, String artifactId, String version, String classifier, String extension, String type, String repository) {
        this(groupId, artifactId, version);
        if (classifier != null && !classifier.isEmpty()) {
            this.properties.put("maven-classifier", classifier);
        }
        if (extension != null && !extension.isEmpty() && !"jar".equalsIgnoreCase(extension)) {
            this.properties.put("maven-extension", extension);
        }
        if (repository != null && !repository.isEmpty()) {
            this.properties.put("maven-repository", repository);
        }
        if (type != null && !type.isEmpty()) {
            this.properties.put("maven-type", type);
        }
    }

    public Map<String, String> getArtifactProperties(IInstallableUnit iu, IArtifactDescriptor descriptor) {
        this.setDescriptorProperties(descriptor);
        return null;
    }

    private void setDescriptorProperties(IArtifactDescriptor descriptor) {
        if (descriptor instanceof ArtifactDescriptor) {
            ArtifactDescriptor artifactDescriptor = (ArtifactDescriptor)descriptor;
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                artifactDescriptor.setProperty(key, value);
            }
        }
    }

    public Map<String, String> getInstallableUnitProperties(MetadataFactory.InstallableUnitDescription iu) {
        return this.properties;
    }

    public boolean isApplicable(String configSpec, boolean includeDefault, String id, Version version) {
        return true;
    }

    public static String getRepository(File file) {
        File repositoriesFile;
        if (file != null && (repositoriesFile = new File(file.getParentFile(), "_remote.repositories")).isFile()) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(repositoriesFile));
                for (String name : properties.stringPropertyNames()) {
                    String[] split = name.split(">", 2);
                    if (split.length != 2 || !split[0].equals(file.getName())) continue;
                    return split[1];
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

