/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.helper;

import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;

public class P2PasswordUtil {
    public static void setCredentials(URI location, String username, String password, Logger logger) {
        ISecurePreferences securePreferences = SecurePreferencesFactory.getDefault();
        String host = location.getHost();
        if (host == null) {
            String scheme = location.getScheme();
            host = URIUtil.isFileURI((URI)location) || scheme == null ? new Path(location.toString()).removeLastSegments(1).toString() : location.toString();
        }
        String nodeKey = URLEncoder.encode(host, StandardCharsets.UTF_8);
        String nodeName = "org.eclipse.equinox.p2.repository/" + nodeKey;
        ISecurePreferences prefNode = securePreferences.node(nodeName);
        try {
            if (!username.equals(prefNode.get("username", username)) || !password.equals(prefNode.get("password", password))) {
                logger.info("Redefining access credentials for repository host " + host);
            }
            prefNode.put("username", username, false);
            prefNode.put("password", password, false);
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }
}

