/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.PermissiveSlicer;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.query.CollectionResult;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;

@Component(role=InstallableUnitSlicer.class)
public class InstallableUnitSlicer {
    @Requirement
    private Logger log;

    public IQueryResult<IInstallableUnit> computeDependencies(Collection<IInstallableUnit> rootIus, IQueryable<IInstallableUnit> avaiableIUs) throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        TychoSlicer slicer = new TychoSlicer(avaiableIUs);
        IQueryable slice = slicer.slice((IInstallableUnit[])rootIus.toArray(IInstallableUnit[]::new), (IProgressMonitor)monitor);
        MultiStatus sliceStatus = slicer.getStatus();
        if (sliceStatus.matches(4)) {
            throw new CoreException((IStatus)sliceStatus);
        }
        if (!sliceStatus.isOK()) {
            this.log.debug("There are warnings from the slicer: " + (IStatus)sliceStatus);
        }
        return slice.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)monitor);
    }

    public IQueryResult<IInstallableUnit> computeDirectDependencies(Collection<IInstallableUnit> rootIus, IQueryable<IInstallableUnit> avaiableIUs) throws CoreException {
        LinkedHashSet<IInstallableUnit> result = new LinkedHashSet<IInstallableUnit>();
        List collect = rootIus.stream().flatMap(iu -> iu.getRequirements().stream()).filter(req -> {
            for (IInstallableUnit unit : rootIus) {
                if (!unit.satisfies(req)) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        block0: for (IInstallableUnit iu2 : avaiableIUs.query(QueryUtil.ALL_UNITS, (IProgressMonitor)new NullProgressMonitor()).toSet()) {
            for (IRequirement requirement : collect) {
                if (!iu2.satisfies(requirement)) continue;
                result.add(iu2);
                continue block0;
            }
        }
        return new CollectionResult(result);
    }

    private final class TychoSlicer
    extends PermissiveSlicer {
        private TychoSlicer(IQueryable<IInstallableUnit> input) {
            super(input, new HashMap(), true, true, true, false, false);
        }

        protected boolean isApplicable(IInstallableUnit unit, IRequirement requirement) {
            if (requirement.isMatch(unit)) {
                InstallableUnitSlicer.this.log.debug("The requirement " + requirement + " is already satisfied by the unit " + unit + " itself, ignoring it.");
                return false;
            }
            return super.isApplicable(unit, requirement);
        }
    }
}

