/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.MethodDescriptor;
import org.junit.jupiter.api.MethodOrdererContext;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.platform.commons.util.ToStringBuilder;

class DefaultMethodOrdererContext
implements MethodOrdererContext {
    private final Class<?> testClass;
    private final List<? extends MethodDescriptor> methodDescriptors;
    private final JupiterConfiguration configuration;

    DefaultMethodOrdererContext(Class<?> testClass, List<? extends MethodDescriptor> methodDescriptors, JupiterConfiguration configuration) {
        this.testClass = testClass;
        this.methodDescriptors = methodDescriptors;
        this.configuration = configuration;
    }

    public final Class<?> getTestClass() {
        return this.testClass;
    }

    public List<? extends MethodDescriptor> getMethodDescriptors() {
        return this.methodDescriptors;
    }

    public Optional<String> getConfigurationParameter(String key) {
        return this.configuration.getRawConfigurationParameter(key);
    }

    public String toString() {
        return new ToStringBuilder(this).append("testClass", this.testClass.getName()).toString();
    }
}

