/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.script;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apiguardian.api.API;
import org.junit.jupiter.engine.script.Script;
import org.junit.jupiter.engine.script.ScriptAccessor;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.INTERNAL, since="5.1")
@Deprecated
public class ScriptExecutionManager {
    private final ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
    private final ConcurrentMap<String, ScriptEngine> scriptEngines = new ConcurrentHashMap<String, ScriptEngine>();
    private final ConcurrentMap<Script, CompiledScript> compiledScripts = new ConcurrentHashMap<Script, CompiledScript>();
    private final ScriptAccessor systemPropertyAccessor = new ScriptAccessor.SystemPropertyAccessor();
    private final ScriptAccessor environmentVariableAccessor = new ScriptAccessor.EnvironmentVariableAccessor();
    boolean forceScriptEvaluation = false;

    public Object evaluate(Script script, Bindings bindings) throws ScriptException {
        CompiledScript compiledScript = (CompiledScript)this.compiledScripts.get(script);
        if (compiledScript == null) {
            String source = script.getSource();
            ScriptEngine scriptEngine = this.scriptEngines.computeIfAbsent(script.getEngine(), this::createScriptEngine);
            if (!(scriptEngine instanceof Compilable) || this.forceScriptEvaluation) {
                return scriptEngine.eval(source, bindings);
            }
            compiledScript = ((Compilable)((Object)scriptEngine)).compile(source);
            this.compiledScripts.putIfAbsent(script, compiledScript);
        }
        return compiledScript.eval(bindings);
    }

    ScriptEngine createScriptEngine(String engine) {
        ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByName(engine);
        if (scriptEngine == null) {
            scriptEngine = this.scriptEngineManager.getEngineByExtension(engine);
        }
        if (scriptEngine == null) {
            scriptEngine = this.scriptEngineManager.getEngineByMimeType(engine);
        }
        Preconditions.notNull(scriptEngine, () -> "Script engine not found: " + engine);
        Bindings bindings = scriptEngine.getBindings(200);
        bindings.put("systemProperty", (Object)this.systemPropertyAccessor);
        bindings.put("systemEnvironment", (Object)this.environmentVariableAccessor);
        return scriptEngine;
    }

    boolean isCompiledScriptsEmpty() {
        return this.compiledScripts.isEmpty();
    }
}

