/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.engine.execution.DefaultParameterContext;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.INTERNAL, since="5.0")
public class ExecutableInvoker {
    private static final Logger logger = LoggerFactory.getLogger(ExecutableInvoker.class);

    public <T> T invoke(Constructor<T> constructor, ExtensionContext extensionContext, ExtensionRegistry extensionRegistry) {
        return ReflectionUtils.newInstance(constructor, this.resolveParameters(constructor, Optional.empty(), extensionContext, extensionRegistry));
    }

    public <T> T invoke(Constructor<T> constructor, Object outerInstance, ExtensionContext extensionContext, ExtensionRegistry extensionRegistry) {
        return ReflectionUtils.newInstance(constructor, this.resolveParameters(constructor, Optional.empty(), outerInstance, extensionContext, extensionRegistry));
    }

    public Object invoke(Method method, ExtensionContext extensionContext, ExtensionRegistry extensionRegistry) {
        return ReflectionUtils.invokeMethod(method, null, this.resolveParameters(method, Optional.empty(), extensionContext, extensionRegistry));
    }

    public Object invoke(Method method, Object target, ExtensionContext extensionContext, ExtensionRegistry extensionRegistry) {
        Optional<Object> optionalTarget = target instanceof Optional ? (Optional<Object>)target : Optional.ofNullable(target);
        return ReflectionUtils.invokeMethod(method, target, this.resolveParameters(method, optionalTarget, extensionContext, extensionRegistry));
    }

    private Object[] resolveParameters(Executable executable, Optional<Object> target, ExtensionContext extensionContext, ExtensionRegistry extensionRegistry) {
        return this.resolveParameters(executable, target, null, extensionContext, extensionRegistry);
    }

    private Object[] resolveParameters(Executable executable, Optional<Object> target, Object outerInstance, ExtensionContext extensionContext, ExtensionRegistry extensionRegistry) {
        Preconditions.notNull(target, "target must not be null");
        Parameter[] parameters = executable.getParameters();
        Object[] values = new Object[parameters.length];
        int start = 0;
        if (outerInstance != null) {
            values[0] = outerInstance;
            start = 1;
        }
        for (int i = start; i < parameters.length; ++i) {
            DefaultParameterContext parameterContext = new DefaultParameterContext(parameters[i], i, target);
            values[i] = this.resolveParameter(parameterContext, executable, extensionContext, extensionRegistry);
        }
        return values;
    }

    private Object resolveParameter(ParameterContext parameterContext, Executable executable, ExtensionContext extensionContext, ExtensionRegistry extensionRegistry) {
        try {
            List matchingResolvers = extensionRegistry.stream(ParameterResolver.class).filter(resolver -> resolver.supportsParameter(parameterContext, extensionContext)).collect(Collectors.toList());
            if (matchingResolvers.isEmpty()) {
                throw new ParameterResolutionException(String.format("No ParameterResolver registered for parameter [%s] in executable [%s].", parameterContext.getParameter(), executable.toGenericString()));
            }
            if (matchingResolvers.size() > 1) {
                String resolverNames = matchingResolvers.stream().map(resolver -> resolver.getClass().getName()).collect(Collectors.joining(", "));
                throw new ParameterResolutionException(String.format("Discovered multiple competing ParameterResolvers for parameter [%s] in executable [%s]: %s", parameterContext.getParameter(), executable.toGenericString(), resolverNames));
            }
            ParameterResolver resolver2 = (ParameterResolver)matchingResolvers.get(0);
            Object value = resolver2.resolveParameter(parameterContext, extensionContext);
            this.validateResolvedType(parameterContext.getParameter(), value, executable, resolver2);
            logger.trace(() -> String.format("ParameterResolver [%s] resolved a value of type [%s] for parameter [%s] in executable [%s].", resolver2.getClass().getName(), value != null ? value.getClass().getName() : null, parameterContext.getParameter(), executable.toGenericString()));
            return value;
        }
        catch (ParameterResolutionException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new ParameterResolutionException(String.format("Failed to resolve parameter [%s] in executable [%s]", parameterContext.getParameter(), executable.toGenericString()), ex);
        }
    }

    private void validateResolvedType(Parameter parameter, Object value, Executable executable, ParameterResolver resolver) {
        Class<?> type = parameter.getType();
        if (!ReflectionUtils.isAssignableTo(value, type)) {
            String message = value == null && type.isPrimitive() ? String.format("ParameterResolver [%s] resolved a null value for parameter [%s] in executable [%s], but a primitive of type [%s] is required.", resolver.getClass().getName(), parameter, executable.toGenericString(), type.getName()) : String.format("ParameterResolver [%s] resolved a value of type [%s] for parameter [%s] in executable [%s], but a value assignment compatible with [%s] is required.", resolver.getClass().getName(), value != null ? value.getClass().getName() : null, parameter, executable.toGenericString(), type.getName());
            throw new ParameterResolutionException(message);
        }
    }
}

