/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.maven.surefire.api.report.LegacyPojoStackTraceWriter;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.report.RunListener;
import org.apache.maven.surefire.api.report.SimpleReportEntry;
import org.apache.maven.surefire.api.report.StackTraceWriter;
import org.apache.maven.surefire.api.testset.TestSetFailedException;
import org.apache.maven.surefire.junit.SurefireTestSet;

public class PojoTestSet
implements SurefireTestSet {
    private static final String TEST_METHOD_PREFIX = "test";
    private static final String SETUP_METHOD_NAME = "setUp";
    private static final String TEARDOWN_METHOD_NAME = "tearDown";
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final Class<?> testClass;
    private final Collection<Method> testMethods = new ArrayList<Method>();
    private Method setUpMethod;
    private Method tearDownMethod;

    public PojoTestSet(Class<?> testClass) {
        if (testClass == null) {
            throw new IllegalArgumentException("testClass is null");
        }
        this.testClass = testClass;
    }

    @Override
    public void execute(RunListener reportManager, ClassLoader loader) throws TestSetFailedException {
        if (reportManager == null) {
            throw new NullPointerException("reportManager is null");
        }
        this.executeTestMethods(reportManager);
    }

    private void executeTestMethods(RunListener reportManager) throws TestSetFailedException {
        Method testMethod;
        boolean abort;
        if (reportManager == null) {
            throw new NullPointerException("reportManager is null");
        }
        this.discoverTestMethods();
        Iterator<Method> iterator = this.testMethods.iterator();
        while (iterator.hasNext() && !(abort = this.executeTestMethod(testMethod = iterator.next(), reportManager))) {
        }
    }

    private boolean executeTestMethod(Method method, RunListener reportManager) throws TestSetFailedException {
        LegacyPojoStackTraceWriter stackTraceWriter;
        Object testObject;
        if (method == null || reportManager == null) {
            throw new NullPointerException();
        }
        try {
            testObject = this.testClass.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new TestSetFailedException("Unable to instantiate POJO '" + this.testClass + "'.", (Throwable)e);
        }
        String testClassName = this.getTestClass().getName();
        String methodName = method.getName();
        String userFriendlyMethodName = methodName + "()";
        String testName = this.getTestName(userFriendlyMethodName);
        reportManager.testStarting((ReportEntry)new SimpleReportEntry(testClassName, null, testName, null));
        try {
            this.setUpFixture(testObject);
        }
        catch (Throwable e) {
            LegacyPojoStackTraceWriter stackTraceWriter2 = new LegacyPojoStackTraceWriter(testClassName, methodName, e);
            reportManager.testFailed((ReportEntry)SimpleReportEntry.withException((String)testClassName, null, (String)testName, null, (StackTraceWriter)stackTraceWriter2));
            return true;
        }
        try {
            method.invoke(testObject, EMPTY_OBJECT_ARRAY);
            reportManager.testSucceeded((ReportEntry)new SimpleReportEntry(testClassName, null, testName, null));
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            LegacyPojoStackTraceWriter stackTraceWriter3 = new LegacyPojoStackTraceWriter(testClassName, methodName, t);
            reportManager.testFailed((ReportEntry)SimpleReportEntry.withException((String)testClassName, null, (String)testName, null, (StackTraceWriter)stackTraceWriter3));
        }
        catch (Throwable t) {
            stackTraceWriter = new LegacyPojoStackTraceWriter(testClassName, methodName, t);
            reportManager.testFailed((ReportEntry)SimpleReportEntry.withException((String)testClassName, null, (String)testName, null, (StackTraceWriter)stackTraceWriter));
        }
        try {
            this.tearDownFixture(testObject);
        }
        catch (Throwable t) {
            stackTraceWriter = new LegacyPojoStackTraceWriter(testClassName, methodName, t);
            reportManager.testFailed((ReportEntry)SimpleReportEntry.withException((String)testClassName, null, (String)testName, null, (StackTraceWriter)stackTraceWriter));
            return true;
        }
        return false;
    }

    private String getTestName(String testMethodName) {
        if (testMethodName == null) {
            throw new NullPointerException("testMethodName is null");
        }
        return this.getTestClass().getName() + "." + testMethodName;
    }

    private void setUpFixture(Object testObject) throws Throwable {
        if (this.setUpMethod != null) {
            this.setUpMethod.invoke(testObject, new Object[0]);
        }
    }

    private void tearDownFixture(Object testObject) throws Throwable {
        if (this.tearDownMethod != null) {
            this.tearDownMethod.invoke(testObject, new Object[0]);
        }
    }

    private void discoverTestMethods() {
        for (Method m : this.getTestClass().getMethods()) {
            if (!PojoTestSet.isNoArgsInstanceMethod(m)) continue;
            if (PojoTestSet.isValidTestMethod(m)) {
                this.testMethods.add(m);
                continue;
            }
            if (SETUP_METHOD_NAME.equals(m.getName())) {
                this.setUpMethod = m;
                continue;
            }
            if (!TEARDOWN_METHOD_NAME.equals(m.getName())) continue;
            this.tearDownMethod = m;
        }
    }

    private static boolean isNoArgsInstanceMethod(Method m) {
        boolean isInstanceMethod = !Modifier.isStatic(m.getModifiers());
        boolean returnsVoid = m.getReturnType().equals(Void.TYPE);
        boolean hasNoParams = m.getParameterTypes().length == 0;
        return isInstanceMethod && returnsVoid && hasNoParams;
    }

    private static boolean isValidTestMethod(Method m) {
        return m.getName().startsWith(TEST_METHOD_PREFIX);
    }

    @Override
    public String getName() {
        return this.getTestClass().getName();
    }

    private Class<?> getTestClass() {
        return this.testClass;
    }
}

