/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.tools.mirroring;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.director.PermissiveSlicer;
import org.eclipse.equinox.internal.p2.director.Slicer;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryDescriptor;
import org.eclipse.equinox.p2.internal.repository.tools.SlicingOptions;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.CollectionResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.tycho.p2.tools.RepositoryReference;

public class MirrorApplication
extends org.eclipse.equinox.p2.internal.repository.tools.MirrorApplication {
    private final Map<String, String> extraArtifactRepositoryProperties;
    private final List<RepositoryReference> repositoryReferences;
    private boolean includeAllSource;
    private boolean includeRequiredBundles;
    private boolean includeRequiredFeatures;

    public MirrorApplication(IProvisioningAgent agent, Map<String, String> extraArtifactRepositoryProperties, List<RepositoryReference> repositoryReferences) {
        this.agent = agent;
        this.extraArtifactRepositoryProperties = extraArtifactRepositoryProperties;
        this.repositoryReferences = repositoryReferences;
        this.removeAddedRepositories = false;
    }

    protected IArtifactRepository initializeDestination(RepositoryDescriptor toInit, IArtifactRepositoryManager mgr) throws ProvisionException {
        IArtifactRepository result = super.initializeDestination(toInit, mgr);
        result.setProperty("publishPackFilesAsSiblings", "true");
        this.extraArtifactRepositoryProperties.entrySet().forEach(entry -> {
            String string = result.setProperty((String)entry.getKey(), (String)entry.getValue());
        });
        return result;
    }

    protected Slicer createSlicer(SlicingOptions options) {
        Map context = options.getFilter();
        final boolean includeOptionalDependencies = options.includeOptionalDependencies();
        final boolean onlyFilteredRequirements = options.followOnlyFilteredRequirements();
        final boolean considerFilter = context != null && context.size() > 1;
        IMetadataRepository repository = this.getCompositeMetadataRepository();
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)repository, context, includeOptionalDependencies, options.isEverythingGreedy(), options.forceFilterTo(), options.considerStrictDependencyOnly(), onlyFilteredRequirements){

            protected boolean isApplicable(IInstallableUnit iu, IRequirement req) {
                boolean isFeature;
                IRequiredCapability capability;
                if ((MirrorApplication.this.includeRequiredBundles || MirrorApplication.this.includeRequiredFeatures) && QueryUtil.isGroup((IInstallableUnit)iu) && req instanceof IRequiredCapability && "org.eclipse.equinox.p2.iu".equals((capability = (IRequiredCapability)req).getNamespace()) && ((isFeature = capability.getName().endsWith(".feature.group")) && MirrorApplication.this.includeRequiredFeatures || !isFeature && MirrorApplication.this.includeRequiredBundles)) {
                    if (!includeOptionalDependencies && req.getMin() == 0) {
                        return false;
                    }
                    IMatchExpression filter = req.getFilter();
                    if (considerFilter) {
                        if (onlyFilteredRequirements && filter == null) {
                            return false;
                        }
                        boolean filterMatches = filter == null || filter.isMatch((Object)this.selectionContext);
                        return filterMatches;
                    }
                    return filter != null || !onlyFilteredRequirements;
                }
                return super.isApplicable(req);
            }

            protected void processIU(IInstallableUnit iu) {
                super.processIU(iu);
            }

            protected boolean isApplicable(IInstallableUnit iu) {
                return super.isApplicable(iu);
            }

            protected boolean isApplicable(IRequirement req) {
                throw new UnsupportedOperationException("should never be called!");
            }

            public IQueryable<IInstallableUnit> slice(IInstallableUnit[] ius, IProgressMonitor monitor) {
                IQueryable slice = super.slice(ius, monitor);
                if (MirrorApplication.this.includeAllSource) {
                    Set units = slice.query(QueryUtil.ALL_UNITS, null).toSet();
                    IInstallableUnit sourceUnit = MirrorApplication.createSourceUnit(units);
                    IQueryable queryable = super.slice(new IInstallableUnit[]{sourceUnit}, monitor);
                    units.addAll(queryable.query(QueryUtil.ALL_UNITS, null).toSet());
                    units.remove(sourceUnit);
                    return new CollectionResult((Collection)units);
                }
                return slice;
            }
        };
        return slicer;
    }

    private static final IInstallableUnit createSourceUnit(Collection<IInstallableUnit> units) {
        IRequirement bundleRequirement = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.eclipse.type", (String)"bundle", null, null, (boolean)false, (boolean)false, (boolean)false);
        MetadataFactory.InstallableUnitDescription sourceDescription = new MetadataFactory.InstallableUnitDescription();
        String id = "Source-Bundles-" + UUID.randomUUID();
        sourceDescription.setId(id);
        Version sourceIUVersion = Version.createOSGi((int)1, (int)0, (int)0);
        sourceDescription.setVersion(sourceIUVersion);
        sourceDescription.setCapabilities(new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)id, (Version)sourceIUVersion)});
        sourceDescription.addRequirements((Collection)units.stream().filter(unit -> unit.satisfies(bundleRequirement)).map(MirrorApplication::createSourceBundleRequirement).collect(Collectors.toList()));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)sourceDescription);
    }

    private static IRequirement createSourceBundleRequirement(IInstallableUnit unit) {
        IRequirement optionalGreedySourceBundleRequirement = MetadataFactory.createRequirement((String)"osgi.bundle", (String)(String.valueOf(unit.getId()) + ".source"), (VersionRange)new VersionRange(unit.getVersion(), true, unit.getVersion(), true), null, (boolean)true, (boolean)false, (boolean)true);
        return optionalGreedySourceBundleRequirement;
    }

    protected IMetadataRepository initializeDestination(RepositoryDescriptor toInit, IMetadataRepositoryManager mgr) throws ProvisionException {
        IMetadataRepository result = super.initializeDestination(toInit, mgr);
        List iRepoRefs = this.repositoryReferences.stream().flatMap(MirrorApplication::toSpiRepositoryReferences).collect(Collectors.toList());
        result.addReferences(iRepoRefs);
        return result;
    }

    private static Stream<org.eclipse.equinox.p2.repository.spi.RepositoryReference> toSpiRepositoryReferences(RepositoryReference rr) {
        return Stream.of(MirrorApplication.toSpiRepositoryReference(rr, 0), MirrorApplication.toSpiRepositoryReference(rr, 1));
    }

    private static org.eclipse.equinox.p2.repository.spi.RepositoryReference toSpiRepositoryReference(RepositoryReference rr, int type) {
        return new org.eclipse.equinox.p2.repository.spi.RepositoryReference(URI.create(rr.getLocation()), rr.getName(), type, rr.isEnable() ? 1 : 0);
    }

    public void setIncludeSources(boolean includeAllSource) {
        this.includeAllSource = includeAllSource;
    }

    public void setIncludeRequiredBundles(boolean includeRequiredBundles) {
        this.includeRequiredBundles = includeRequiredBundles;
    }

    public void setIncludeRequiredFeatures(boolean includeRequiredFeatures) {
        this.includeRequiredFeatures = includeRequiredFeatures;
    }
}

