/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.tools.publisher;

import java.util.List;
import org.eclipse.tycho.Interpolator;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.p2.target.P2TargetPlatform;
import org.eclipse.tycho.p2.tools.publisher.PublishProductToolImpl;
import org.eclipse.tycho.p2.tools.publisher.PublisherActionRunner;
import org.eclipse.tycho.p2.tools.publisher.PublisherServiceImpl;
import org.eclipse.tycho.p2.tools.publisher.facade.PublishProductTool;
import org.eclipse.tycho.p2.tools.publisher.facade.PublisherService;
import org.eclipse.tycho.p2.tools.publisher.facade.PublisherServiceFactory;
import org.eclipse.tycho.repository.publishing.PublishingRepository;
import org.eclipse.tycho.repository.registry.ReactorRepositoryManager;

public class PublisherServiceFactoryImpl
implements PublisherServiceFactory {
    private MavenContext mavenContext;
    private ReactorRepositoryManager reactorRepoManager;

    public PublisherService createPublisher(ReactorProject project, List<TargetEnvironment> environments) {
        P2TargetPlatform targetPlatform = (P2TargetPlatform)this.reactorRepoManager.getFinalTargetPlatform(project);
        PublisherActionRunner publisherRunner = this.getPublisherRunnerForProject(targetPlatform, environments);
        PublishingRepository publishingRepository = this.reactorRepoManager.getPublishingRepository(project.getIdentities());
        return new PublisherServiceImpl(publisherRunner, project.getBuildQualifier(), publishingRepository);
    }

    public PublishProductTool createProductPublisher(ReactorProject project, List<TargetEnvironment> environments, String buildQualifier, Interpolator interpolator) {
        P2TargetPlatform targetPlatform = (P2TargetPlatform)this.reactorRepoManager.getFinalTargetPlatform(project);
        PublisherActionRunner publisherRunner = this.getPublisherRunnerForProject(targetPlatform, environments);
        PublishingRepository publishingRepository = this.reactorRepoManager.getPublishingRepository(project.getIdentities());
        return new PublishProductToolImpl(publisherRunner, publishingRepository, targetPlatform, buildQualifier, interpolator, this.mavenContext.getLogger());
    }

    private PublisherActionRunner getPublisherRunnerForProject(P2TargetPlatform targetPlatform, List<TargetEnvironment> environments) {
        this.checkCollaborators();
        return new PublisherActionRunner(targetPlatform.getInstallableUnitsAsMetadataRepository(), environments, this.mavenContext.getLogger());
    }

    public void setMavenContext(MavenContext mavenContext) {
        this.mavenContext = mavenContext;
    }

    public void setReactorRepositoryManager(ReactorRepositoryManager reactorRepoManager) {
        this.reactorRepoManager = reactorRepoManager;
    }

    private void checkCollaborators() {
        if (this.mavenContext == null || this.reactorRepoManager == null) {
            throw new IllegalStateException();
        }
    }
}

