/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.tools.publisher;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.AdviceFileAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.ProductAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.BuildFailureException;
import org.eclipse.tycho.Interpolator;
import org.eclipse.tycho.core.resolver.shared.DependencySeed;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.target.ArtifactTypeHelper;
import org.eclipse.tycho.p2.target.P2TargetPlatform;
import org.eclipse.tycho.p2.tools.publisher.DependencySeedUtil;
import org.eclipse.tycho.p2.tools.publisher.ExpandedProduct;
import org.eclipse.tycho.p2.tools.publisher.ProductBinariesWriteSession;
import org.eclipse.tycho.p2.tools.publisher.PublisherActionRunner;
import org.eclipse.tycho.p2.tools.publisher.facade.PublishProductTool;
import org.eclipse.tycho.repository.publishing.PublishingRepository;
import org.eclipse.tycho.repository.publishing.WriteSessionContext;

public class PublishProductToolImpl
implements PublishProductTool {
    private final P2TargetPlatform targetPlatform;
    private final PublisherActionRunner publisherRunner;
    private final PublishingRepository publishingRepository;
    private final String buildQualifier;
    private final Interpolator interpolator;
    private final MavenLogger logger;

    public PublishProductToolImpl(PublisherActionRunner publisherRunner, PublishingRepository publishingRepository, P2TargetPlatform targetPlatform, String buildQualifier, Interpolator interpolator, MavenLogger logger) {
        this.publisherRunner = publisherRunner;
        this.publishingRepository = publishingRepository;
        this.targetPlatform = targetPlatform;
        this.buildQualifier = buildQualifier;
        this.interpolator = interpolator;
        this.logger = logger;
    }

    public List<DependencySeed> publishProduct(File productFile, File launcherBinaries, String flavor) throws IllegalArgumentException {
        IProductDescriptor originalProduct = PublishProductToolImpl.loadProductFile(productFile);
        ExpandedProduct expandedProduct = new ExpandedProduct(originalProduct, this.buildQualifier, this.targetPlatform, this.interpolator, this.logger);
        IPublisherAdvice[] advice = PublishProductToolImpl.getProductSpecificAdviceFileAdvice(productFile, expandedProduct);
        ProductAction action = new ProductAction(null, (IProductDescriptor)expandedProduct, flavor, launcherBinaries);
        IMetadataRepository metadataRepository = this.publishingRepository.getMetadataRepository();
        IArtifactRepository artifactRepository = this.publishingRepository.getArtifactRepositoryForWriting((WriteSessionContext)new ProductBinariesWriteSession(expandedProduct.getId()));
        Collection<IInstallableUnit> allIUs = this.publisherRunner.executeAction((IPublisherAction)action, metadataRepository, artifactRepository, advice);
        ArrayList<DependencySeed> seeds = new ArrayList<DependencySeed>();
        seeds.add(DependencySeedUtil.createSeed("eclipse-product", PublishProductToolImpl.selectUnit(allIUs, expandedProduct.getId())));
        PublishProductToolImpl.addRootFeatures(expandedProduct, seeds);
        return seeds;
    }

    private static IPublisherAdvice[] getProductSpecificAdviceFileAdvice(File productFile, IProductDescriptor expandedProduct) {
        AdviceFileAdvice advice = new AdviceFileAdvice(expandedProduct.getId(), Version.parseVersion((String)expandedProduct.getVersion()), (IPath)new Path(productFile.getParent()), (IPath)new Path(PublishProductToolImpl.getProductSpecificP2InfName(productFile.getName())));
        if (advice.containsAdvice()) {
            return new IPublisherAdvice[]{advice};
        }
        return new IPublisherAdvice[0];
    }

    private static String getProductSpecificP2InfName(String productFileName) {
        String p2infFilename = String.valueOf(productFileName.substring(0, productFileName.length() - ".product".length())) + ".p2.inf";
        return p2infFilename;
    }

    private static void addRootFeatures(ExpandedProduct product, List<DependencySeed> seeds) {
        String productId = product.getId();
        DependencySeed.Filter filter = (type, id) -> "eclipse-product".equals(type) && productId.equals(id);
        for (IInstallableUnit featureIU : product.getRootFeatures()) {
            ArtifactKey featureArtifact = ArtifactTypeHelper.toTychoArtifact((IInstallableUnit)featureIU);
            seeds.add(new DependencySeed(featureArtifact.getType(), featureArtifact.getId(), featureIU, filter));
        }
    }

    private static IProductDescriptor loadProductFile(File productFile) throws IllegalArgumentException {
        try {
            return new ProductFile(productFile.getAbsolutePath());
        }
        catch (Exception e) {
            throw new BuildFailureException("Cannot parse product file " + productFile.getAbsolutePath() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private static IInstallableUnit selectUnit(Collection<IInstallableUnit> units, String id) {
        for (IInstallableUnit unit : units) {
            if (!id.equals(unit.getId())) continue;
            return unit;
        }
        throw new AssertionFailedException("Publisher did not produce expected IU");
    }
}

