/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.remote;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.ecf.provider.filetransfer.util.ProxySetupHelper;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.tycho.MavenRepositorySettings;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.remote.CacheEntry;

public class SharedHttpCacheStorage {
    public static final long MIN_CACHE_PERIOD = Long.getLong("tycho.p2.transport.min-cache-minutes", TimeUnit.HOURS.toMinutes(1L));
    private static final String PROXY_AUTHORIZATION_HEADER = "Proxy-Authorization";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String LAST_MODIFIED_HEADER = "Last-Modified";
    private static final String EXPIRES_HEADER = "Expires";
    private static final String CACHE_CONTROL_HEADER = "Cache-Control";
    private static final String MAX_AGE_DIRECTIVE = "max-age";
    private static final String MUST_REVALIDATE_DIRECTIVE = "must-revalidate";
    private static final String ETAG_HEADER = "ETag";
    private static final Map<CacheConfig, SharedHttpCacheStorage> storageMap = new HashMap<CacheConfig, SharedHttpCacheStorage>();
    private static final int MAX_IN_MEMORY = 1000;
    private final Map<File, CacheLine> entryCache;
    private CacheConfig cacheConfig;

    private SharedHttpCacheStorage(CacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
        this.entryCache = new LinkedHashMap<File, CacheLine>(100, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<File, CacheLine> eldest) {
                return this.size() > 1000;
            }
        };
    }

    public CacheEntry getCacheEntry(final URI uri, final MavenLogger logger) throws FileNotFoundException {
        final CacheLine cacheLine = this.getCacheLine(uri);
        if (!this.cacheConfig.update) {
            int code = cacheLine.getResponseCode();
            if (code == 404) {
                throw new FileNotFoundException(uri.toASCIIString());
            }
            if (code == 301) {
                return this.getCacheEntry(cacheLine.getRedirect(uri), logger);
            }
        }
        return new CacheEntry(){

            @Override
            public long getLastModified(IProxyService proxyService, Function<URI, MavenRepositorySettings.Credentials> credentialsProvider) throws IOException {
                if (SharedHttpCacheStorage.this.cacheConfig.offline) {
                    return cacheLine.getLastModified(uri, proxyService, credentialsProvider, SharedHttpCacheStorage::access$0, logger);
                }
                try {
                    return cacheLine.fetchLastModified(uri, proxyService, credentialsProvider, logger);
                }
                catch (FileNotFoundException | AuthenticationFailedException e) {
                    throw e;
                }
                catch (IOException e) {
                    if (!SharedHttpCacheStorage.this.cacheConfig.update && cacheLine.getResponseCode() > 0) {
                        logger.warn("Request to " + uri + " failed, trying cache instead...");
                        return cacheLine.getLastModified(uri, proxyService, credentialsProvider, nil -> e, logger);
                    }
                    throw e;
                }
            }

            @Override
            public File getCacheFile(IProxyService proxyService, Function<URI, MavenRepositorySettings.Credentials> credentialsProvider) throws IOException {
                if (SharedHttpCacheStorage.this.cacheConfig.offline) {
                    return cacheLine.getFile(uri, proxyService, credentialsProvider, SharedHttpCacheStorage::access$0, logger);
                }
                try {
                    return cacheLine.fetchFile(uri, proxyService, credentialsProvider, logger);
                }
                catch (FileNotFoundException | AuthenticationFailedException e) {
                    throw e;
                }
                catch (IOException e) {
                    if (!SharedHttpCacheStorage.this.cacheConfig.update && cacheLine.getResponseCode() > 0) {
                        logger.warn("Request to " + uri + " failed, trying cache instead...");
                        return cacheLine.getFile(uri, proxyService, credentialsProvider, nil -> e, logger);
                    }
                    throw e;
                }
            }
        };
    }

    private synchronized CacheLine getCacheLine(URI uri) {
        File location;
        File file = new File(this.cacheConfig.location, uri.normalize().toASCIIString().replace(':', '/').replace('?', '/').replace('&', '/').replaceAll("/+", "/"));
        try {
            location = file.getCanonicalFile();
        }
        catch (IOException e) {
            location = file.getAbsoluteFile();
        }
        return this.entryCache.computeIfAbsent(location, arg_0 -> CacheLine.new(this, arg_0));
    }

    private static IProxyData getProxyData(IProxyService proxyService, URI uri) throws IOException {
        if (proxyService != null) {
            IProxyData[] selected = proxyService.select(uri);
            IProxyData proxyData = ProxySetupHelper.selectProxyFromProxies((String)uri.getScheme(), (IProxyData[])selected);
            if (proxyData != null) {
                return proxyData;
            }
        }
        return null;
    }

    private static boolean isRedirected(int code) {
        return code == 301 || code == 302;
    }

    private static boolean isNotFound(int code) {
        return code == 404;
    }

    public static SharedHttpCacheStorage getStorage(File location, boolean offline, boolean update) {
        return storageMap.computeIfAbsent(new CacheConfig(location, offline, update), SharedHttpCacheStorage::new);
    }

    private static IOException mavenIsOffline(URI uri) {
        return new IOException("maven is currently in offline mode requested URL " + uri + " does not exist locally!");
    }

    static /* synthetic */ IOException access$0(URI uRI) {
        return SharedHttpCacheStorage.mavenIsOffline(uRI);
    }

    private static final class CacheConfig {
        private final File location;
        private final boolean offline;
        private final boolean update;

        public CacheConfig(File location, boolean offline, boolean update) {
            this.location = location;
            this.offline = offline;
            this.update = update;
        }

        public int hashCode() {
            return Objects.hash(this.location, this.offline, this.update);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheConfig other = (CacheConfig)obj;
            return Objects.equals(this.location, other.location) && this.offline == other.offline && this.update == other.update;
        }
    }

    private final class CacheLine {
        private static final String RESPONSE_CODE = "HTTP_RESPONSE_CODE";
        private static final String LAST_UPDATED = "FILE-LAST_UPDATED";
        private static final String STATUS_LINE = "HTTP_STATUS_LINE";
        private final File file;
        private final File headerFile;
        private Properties header;
        private final DateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);

        public CacheLine(File file) {
            this.file = file;
            this.headerFile = new File(file.getParent(), String.valueOf(file.getName()) + ".headers");
            this.httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }

        public synchronized long fetchLastModified(URI uri, IProxyService proxyService, Function<URI, MavenRepositorySettings.Credentials> credentialsProvider, MavenLogger logger) throws IOException {
            RepositoryAuthenticator authenticator = new RepositoryAuthenticator(SharedHttpCacheStorage.getProxyData(proxyService, uri), credentialsProvider.apply(uri));
            HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection(authenticator.getProxy());
            connection.setAuthenticator(authenticator);
            connection.setRequestMethod("HEAD");
            authenticator.preemtiveAuth(connection);
            connection.connect();
            try {
                int code = connection.getResponseCode();
                if (this.isAuthFailure(code)) {
                    throw new AuthenticationFailedException();
                }
                if (SharedHttpCacheStorage.isNotFound(code)) {
                    this.updateHeader(connection, code);
                    throw new FileNotFoundException(uri.toString());
                }
                if (SharedHttpCacheStorage.isRedirected(code)) {
                    this.updateHeader(connection, code);
                    long l = SharedHttpCacheStorage.this.getCacheEntry(uri, logger).getLastModified(proxyService, credentialsProvider);
                    return l;
                }
                long l = connection.getLastModified();
                return l;
            }
            finally {
                this.closeConnection(connection);
            }
        }

        public synchronized long getLastModified(URI uri, IProxyService proxyService, Function<URI, MavenRepositorySettings.Credentials> credentialsProvider, Function<URI, IOException> notAviableExceptionSupplier, MavenLogger logger) throws IOException {
            int code = this.getResponseCode();
            if (code > 0) {
                if (this.isAuthFailure(code)) {
                    throw new AuthenticationFailedException();
                }
                if (SharedHttpCacheStorage.isNotFound(code)) {
                    throw new FileNotFoundException(uri.toString());
                }
                if (SharedHttpCacheStorage.isRedirected(code)) {
                    return SharedHttpCacheStorage.this.getCacheEntry(uri, logger).getLastModified(proxyService, credentialsProvider);
                }
                Properties offlineHeader = this.getHeader();
                Date lastModified = this.pareHttpDate(offlineHeader.getProperty(SharedHttpCacheStorage.LAST_MODIFIED_HEADER.toLowerCase()));
                if (lastModified != null) {
                    return lastModified.getTime();
                }
                return -1L;
            }
            throw notAviableExceptionSupplier.apply(uri);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized File fetchFile(URI uri, IProxyService proxyService, Function<URI, MavenRepositorySettings.Credentials> credentialsProvider, MavenLogger logger) throws IOException {
            File tempFile;
            block23: {
                boolean exits = this.file.isFile();
                if (exits && !this.mustValidate()) {
                    return this.file;
                }
                RepositoryAuthenticator authenticator = new RepositoryAuthenticator(SharedHttpCacheStorage.getProxyData(proxyService, uri), credentialsProvider.apply(uri));
                HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection(authenticator.getProxy());
                connection.setAuthenticator(authenticator);
                authenticator.preemtiveAuth(connection);
                Properties lastHeader = this.getHeader();
                if (exits) {
                    if (lastHeader.containsKey(SharedHttpCacheStorage.ETAG_HEADER.toLowerCase())) {
                        connection.setRequestProperty("If-None-Match", lastHeader.getProperty(SharedHttpCacheStorage.ETAG_HEADER.toLowerCase()));
                    }
                    if (lastHeader.contains(SharedHttpCacheStorage.LAST_MODIFIED_HEADER.toLowerCase())) {
                        connection.setRequestProperty("If-Modified-Since", lastHeader.getProperty(SharedHttpCacheStorage.LAST_MODIFIED_HEADER.toLowerCase()));
                    }
                }
                connection.setInstanceFollowRedirects(false);
                connection.connect();
                int code = connection.getResponseCode();
                if (exits && code == 304) {
                    this.updateHeader(connection, this.getResponseCode());
                    return this.file;
                }
                if (this.isAuthFailure(code)) {
                    throw new AuthenticationFailedException();
                }
                this.updateHeader(connection, code);
                if (SharedHttpCacheStorage.isRedirected(code)) {
                    this.closeConnection(connection);
                    return SharedHttpCacheStorage.this.getCacheEntry(this.getRedirect(uri), logger).getCacheFile(proxyService, credentialsProvider);
                }
                if (exits) {
                    FileUtils.forceDelete((File)this.file);
                }
                tempFile = File.createTempFile("download", ".tmp", this.file.getParentFile());
                try {
                    Throwable throwable = null;
                    Object var12_14 = null;
                    try {
                        InputStream inputStream = connection.getInputStream();
                        try {
                            try (FileOutputStream os = new FileOutputStream(tempFile);){
                                inputStream.transferTo(os);
                            }
                            if (inputStream == null) break block23;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (inputStream == null) throw throwable;
                            inputStream.close();
                            throw throwable;
                        }
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    tempFile.delete();
                    throw e;
                }
            }
            FileUtils.moveFile((File)tempFile, (File)this.file);
            return this.file;
        }

        public synchronized File getFile(URI uri, IProxyService proxyService, Function<URI, MavenRepositorySettings.Credentials> credentialsProvider, Function<URI, IOException> notAviableExceptionSupplier, MavenLogger logger) throws IOException {
            int code = this.getResponseCode();
            if (code > 0) {
                if (this.isAuthFailure(code)) {
                    throw new AuthenticationFailedException();
                }
                if (SharedHttpCacheStorage.isNotFound(code)) {
                    throw new FileNotFoundException(uri.toString());
                }
                if (SharedHttpCacheStorage.isRedirected(code)) {
                    return SharedHttpCacheStorage.this.getCacheEntry(this.getRedirect(uri), logger).getCacheFile(proxyService, credentialsProvider);
                }
                if (this.file.isFile()) {
                    return this.file;
                }
            }
            throw notAviableExceptionSupplier.apply(uri);
        }

        private boolean mustValidate() {
            String[] cacheControls;
            if (SharedHttpCacheStorage.this.cacheConfig.update) {
                return true;
            }
            String[] stringArray = cacheControls = this.getCacheControl();
            int n = cacheControls.length;
            int n2 = 0;
            while (n2 < n) {
                String directive = stringArray[n2];
                if (SharedHttpCacheStorage.MUST_REVALIDATE_DIRECTIVE.equals(directive)) {
                    return true;
                }
                ++n2;
            }
            Properties properties = this.getHeader();
            long lastUpdated = this.parseLong(properties.getProperty(LAST_UPDATED));
            if (lastUpdated + TimeUnit.MINUTES.toMillis(MIN_CACHE_PERIOD) > System.currentTimeMillis()) {
                return false;
            }
            String[] stringArray2 = cacheControls;
            int n3 = cacheControls.length;
            int n4 = 0;
            while (n4 < n3) {
                String directive = stringArray2[n4];
                if (directive.toLowerCase().startsWith(SharedHttpCacheStorage.MAX_AGE_DIRECTIVE)) {
                    long maxAge = this.parseLong(directive.substring(SharedHttpCacheStorage.MAX_AGE_DIRECTIVE.length() + 1));
                    if (maxAge <= 0L) {
                        return true;
                    }
                    return lastUpdated + TimeUnit.SECONDS.toMillis(maxAge) < System.currentTimeMillis();
                }
                ++n4;
            }
            Date expiresDate = this.pareHttpDate(properties.getProperty(SharedHttpCacheStorage.EXPIRES_HEADER.toLowerCase()));
            if (expiresDate != null) {
                return expiresDate.after(new Date());
            }
            return true;
        }

        protected long parseLong(String value) {
            if (value != null) {
                try {
                    return Long.parseLong(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 0L;
        }

        private String[] getCacheControl() {
            String property = this.getHeader().getProperty(SharedHttpCacheStorage.CACHE_CONTROL_HEADER);
            if (property != null) {
                return property.split(",\\s*");
            }
            return new String[0];
        }

        protected boolean isAuthFailure(int code) {
            return code == 407 || code == 401;
        }

        protected void updateHeader(HttpURLConnection connection, int code) throws IOException, FileNotFoundException {
            this.header = new Properties();
            this.header.setProperty(RESPONSE_CODE, String.valueOf(code));
            this.header.setProperty(LAST_UPDATED, String.valueOf(System.currentTimeMillis()));
            Map<String, List<String>> headerFields = connection.getHeaderFields();
            for (Map.Entry<String, List<String>> entry : headerFields.entrySet()) {
                String key = entry.getKey();
                if (key == null) {
                    key = STATUS_LINE;
                }
                if (SharedHttpCacheStorage.AUTHORIZATION_HEADER.equalsIgnoreCase(key = key.toLowerCase()) || SharedHttpCacheStorage.PROXY_AUTHORIZATION_HEADER.equalsIgnoreCase(key) || key.toLowerCase().startsWith("x-")) continue;
                List<String> value = entry.getValue();
                if (value.size() == 1) {
                    this.header.put(key, value.get(0));
                    continue;
                }
                this.header.put(key, value.stream().collect(Collectors.joining(",")));
            }
            FileUtils.forceMkdir((File)this.file.getParentFile());
            Throwable throwable = null;
            Iterator<Map.Entry<String, List<String>>> iterator = null;
            try (FileOutputStream out = new FileOutputStream(this.headerFile);){
                this.header.store(out, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        private synchronized Date pareHttpDate(String input) {
            if (input != null) {
                try {
                    return this.httpDateFormat.parse(input);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return null;
        }

        private void closeConnection(HttpURLConnection connection) {
            try {
                connection.getInputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public int getResponseCode() {
            return Integer.parseInt(this.getHeader().getProperty(RESPONSE_CODE, "-1"));
        }

        public URI getRedirect(URI base) throws FileNotFoundException {
            String location = this.getHeader().getProperty("location");
            if (location == null) {
                throw new FileNotFoundException(base.toASCIIString());
            }
            return base.resolve(location);
        }

        public Properties getHeader() {
            if (this.header == null) {
                this.header = new Properties();
                if (this.headerFile.isFile()) {
                    try {
                        this.header.load(new FileInputStream(this.headerFile));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            return this.header;
        }
    }

    private static final class RepositoryAuthenticator
    extends Authenticator {
        private IProxyData proxyData;
        private MavenRepositorySettings.Credentials credentials;

        public RepositoryAuthenticator(IProxyData proxyData, MavenRepositorySettings.Credentials credentials) {
            this.proxyData = proxyData;
            this.credentials = credentials;
        }

        public void preemtiveAuth(HttpURLConnection connection) {
            this.addAuthHeader(connection, this.getPasswordAuthentication(Authenticator.RequestorType.PROXY), SharedHttpCacheStorage.PROXY_AUTHORIZATION_HEADER);
            this.addAuthHeader(connection, this.getPasswordAuthentication(Authenticator.RequestorType.SERVER), SharedHttpCacheStorage.AUTHORIZATION_HEADER);
        }

        private void addAuthHeader(HttpURLConnection connection, PasswordAuthentication authentication, String header) {
            if (authentication == null) {
                return;
            }
            String encoding = Base64.getEncoder().encodeToString((String.valueOf(authentication.getUserName()) + ":" + new String(authentication.getPassword())).getBytes());
            connection.setRequestProperty(header, "Basic " + encoding);
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return this.getPasswordAuthentication(this.getRequestorType());
        }

        protected PasswordAuthentication getPasswordAuthentication(Authenticator.RequestorType type) {
            String userName;
            if (type == Authenticator.RequestorType.PROXY) {
                String userId;
                if (this.proxyData != null && (userId = this.proxyData.getUserId()) != null) {
                    String password = this.proxyData.getPassword();
                    return new PasswordAuthentication(userId, password == null ? new char[]{} : password.toCharArray());
                }
            } else if (type == Authenticator.RequestorType.SERVER && this.credentials != null && (userName = this.credentials.getUserName()) != null) {
                String password = this.credentials.getPassword();
                return new PasswordAuthentication(userName, password == null ? new char[]{} : password.toCharArray());
            }
            return null;
        }

        public Proxy getProxy() {
            if (this.proxyData == null) {
                return Proxy.NO_PROXY;
            }
            return new Proxy(RepositoryAuthenticator.convertType(this.proxyData), RepositoryAuthenticator.convertAddress(this.proxyData));
        }

        private static SocketAddress convertAddress(IProxyData data) {
            return new InetSocketAddress(data.getHost(), data.getPort());
        }

        private static Proxy.Type convertType(IProxyData data) {
            switch (data.getType()) {
                case "HTTP": 
                case "HTTPS": {
                    return Proxy.Type.HTTP;
                }
                case "SOCKS": {
                    return Proxy.Type.SOCKS;
                }
            }
            return Proxy.Type.DIRECT;
        }
    }
}

