/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.util.resolution;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.equinox.internal.p2.director.PermissiveSlicer;
import org.eclipse.equinox.internal.p2.director.Slicer;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.core.shared.TargetEnvironment;
import org.eclipse.tycho.p2.util.resolution.AbstractSlicerResolutionStrategy;
import org.eclipse.tycho.p2.util.resolution.ResolverDebugUtils;
import org.eclipse.tycho.p2.util.resolution.ResolverException;

public class SlicerResolutionStrategy
extends AbstractSlicerResolutionStrategy {
    private boolean ignoreFilters;
    private boolean warnIfMissing;

    public SlicerResolutionStrategy(MavenLogger logger, boolean ignoreFilters, boolean warnIfMissing) {
        super(logger);
        this.ignoreFilters = ignoreFilters;
        this.warnIfMissing = warnIfMissing;
    }

    @Override
    protected Slicer newSlicer(IQueryable<IInstallableUnit> availableIUs, Map<String, String> properties) {
        boolean evalFilterTo;
        Map<Object, Object> context;
        if (this.ignoreFilters) {
            context = Collections.emptyMap();
            evalFilterTo = true;
        } else {
            context = properties;
            evalFilterTo = false;
        }
        return new PermissiveSlicer(availableIUs, context, true, false, evalFilterTo, true, false);
    }

    @Override
    protected boolean isSlicerError(MultiStatus slicerStatus) {
        if (this.warnIfMissing && this.logger.isExtendedDebugEnabled()) {
            StringBuilder msg = new StringBuilder("Following dependencies were not found by the slicer (you can disregard this if it is intentional):\n");
            boolean anyWarnPresent = false;
            IStatus[] iStatusArray = slicerStatus.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus statusItem = iStatusArray[n2];
                if (statusItem.getSeverity() == 2) {
                    anyWarnPresent = true;
                    msg.append(statusItem.getMessage()).append("\n");
                }
                ++n2;
            }
            if (anyWarnPresent) {
                this.logger.warn(msg.toString());
            }
        }
        return slicerStatus.matches(12);
    }

    @Override
    public Collection<IInstallableUnit> multiPlatformResolve(List<TargetEnvironment> environments, IProgressMonitor monitor) throws ResolverException {
        if (this.ignoreFilters) {
            return this.resolve(Collections.emptyMap(), monitor);
        }
        return super.multiPlatformResolve(environments, monitor);
    }

    @Override
    public Collection<IInstallableUnit> resolve(Map<String, String> properties, IProgressMonitor monitor) throws ResolverException {
        IQueryable<IInstallableUnit> slice = this.slice(properties, monitor);
        LinkedHashSet<IInstallableUnit> result = new LinkedHashSet<IInstallableUnit>(slice.query(QueryUtil.ALL_UNITS, monitor).toUnmodifiableSet());
        result.removeAll(this.data.getEEResolutionHints().getTemporaryAdditions());
        if (this.logger.isExtendedDebugEnabled()) {
            this.logger.debug("Resolved IUs:\n" + ResolverDebugUtils.toDebugString(result, false));
        }
        return result;
    }
}

