/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.resolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureParser;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.AbstractArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.spi.AbstractMetadataRepository;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.tycho.p2.target.TargetDefinitionContent;
import org.eclipse.tycho.p2.target.facade.TargetDefinitionResolutionException;
import org.eclipse.tycho.p2.util.resolution.ResolverException;
import org.osgi.framework.BundleException;

public class FileTargetDefinitionContent
implements TargetDefinitionContent {
    private Map<IArtifactDescriptor, IInstallableUnit> repositoryContent = new HashMap<IArtifactDescriptor, IInstallableUnit>();
    private final FileMetadataRepository metadataRepository;
    private final FileArtifactRepository artifactRepository;
    private File location;
    private boolean loaded;

    public FileTargetDefinitionContent(IProvisioningAgent agent, File location) {
        this.location = location;
        this.metadataRepository = new FileMetadataRepository(location, agent, () -> this.getRepositoryContent().values().iterator());
        this.artifactRepository = new FileArtifactRepository(location, agent, () -> this.getRepositoryContent().keySet().iterator());
    }

    @Override
    public IMetadataRepository getMetadataRepository() {
        this.preload(null);
        return this.metadataRepository;
    }

    @Override
    public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        this.preload((IProgressMonitor)subMonitor.split(100));
        subMonitor.setWorkRemaining(100);
        return this.getMetadataRepository().query(query, (IProgressMonitor)subMonitor.split(100));
    }

    public synchronized void preload(IProgressMonitor monitor) {
        if (this.loaded) {
            return;
        }
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
            File pluginsPath = new File(this.location, "plugins");
            File featurePath = new File(this.location, "features");
            boolean hasPlugins = pluginsPath.isDirectory();
            boolean hasFeatures = featurePath.isDirectory();
            if (hasPlugins) {
                FileTargetDefinitionContent.readBundles(pluginsPath, this.repositoryContent::put, (IProgressMonitor)(hasFeatures ? subMonitor.split(100) : subMonitor));
            }
            if (hasFeatures) {
                FileTargetDefinitionContent.readFeatures(featurePath, this.repositoryContent::put, (IProgressMonitor)(hasPlugins ? subMonitor.split(100) : subMonitor));
            }
            if (!hasFeatures && !hasPlugins) {
                FileTargetDefinitionContent.readBundles(this.location, this.repositoryContent::put, (IProgressMonitor)subMonitor.split(100));
                FileTargetDefinitionContent.readFeatures(this.location, this.repositoryContent::put, (IProgressMonitor)subMonitor.split(100));
            }
        }
        catch (ResolverException e) {
            throw new TargetDefinitionResolutionException("resolving location " + this.location + " failed", (Throwable)e);
        }
        this.loaded = true;
    }

    @Override
    public IArtifactRepository getArtifactRepository() {
        this.preload(null);
        return this.artifactRepository;
    }

    private Map<IArtifactDescriptor, IInstallableUnit> getRepositoryContent() {
        return this.repositoryContent;
    }

    private static void readFeatures(File path, BiConsumer<IArtifactDescriptor, IInstallableUnit> consumer, IProgressMonitor monitor) throws ResolverException {
        File[] files;
        PublisherInfo publisherInfo = new PublisherInfo();
        publisherInfo.setArtifactOptions(1);
        if (path.isDirectory() && (files = path.listFiles()) != null) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("reading features from path " + path + "..."), (int)files.length);
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File featureLocation = fileArray[n2];
                if (monitor.isCanceled()) break;
                String name = featureLocation.getName();
                if (!(name.startsWith(".") || featureLocation.isFile() && !name.toLowerCase().endsWith(".jar"))) {
                    subMonitor.subTask("Reading " + name);
                    Feature feature = new FeatureParser().parse(featureLocation);
                    if (feature != null) {
                        feature.setLocation(featureLocation.getAbsolutePath());
                        consumer.accept((IArtifactDescriptor)new FileArtifactDescriptor(featureLocation, FeaturesAction.createFeatureArtifactKey((String)feature.getId(), (String)feature.getVersion())), FeaturesAction.createFeatureJarIU((Feature)feature, (IPublisherInfo)publisherInfo));
                    }
                    subMonitor.worked(1);
                }
                ++n2;
            }
        }
    }

    private static void readBundles(File path, BiConsumer<IArtifactDescriptor, IInstallableUnit> consumer, IProgressMonitor monitor) throws ResolverException {
        File[] files;
        PublisherInfo publisherInfo = new PublisherInfo();
        publisherInfo.setArtifactOptions(1);
        if (path.isDirectory() && (files = path.listFiles()) != null) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("reading bundles from path " + path + "..."), (int)files.length);
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File bundleLocation = fileArray[n2];
                if (monitor.isCanceled()) break;
                String name = bundleLocation.getName();
                if (!(name.startsWith(".") || bundleLocation.isFile() && !name.toLowerCase().endsWith(".jar"))) {
                    subMonitor.subTask("Reading " + name);
                    try {
                        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)bundleLocation);
                        if (bundleDescription != null) {
                            IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
                            consumer.accept((IArtifactDescriptor)new FileArtifactDescriptor(bundleLocation, key), BundlesAction.createBundleIU((BundleDescription)bundleDescription, (IArtifactKey)key, (IPublisherInfo)publisherInfo));
                        }
                    }
                    catch (IOException | BundleException e) {
                        throw new ResolverException("Reading bundle failed", e);
                    }
                    subMonitor.worked(1);
                }
                ++n2;
            }
        }
    }

    private static boolean matches(IArtifactKey key, IArtifactDescriptor descriptor) {
        IArtifactKey descriptorKey = descriptor.getArtifactKey();
        return descriptorKey == key || key.getId().equals(descriptorKey.getId()) && key.getClassifier().equals(descriptorKey.getClassifier()) && key.getVersion().equals(descriptorKey.getVersion());
    }

    private static final class FileArtifactDescriptor
    extends ArtifactDescriptor {
        private File file;

        private FileArtifactDescriptor(File file, IArtifactKey key) {
            super(key);
            this.file = file;
        }
    }

    private static class FileArtifactRepository
    extends AbstractArtifactRepository
    implements IFileArtifactRepository {
        private Supplier<Iterator<IArtifactDescriptor>> descriptorSupplier;

        protected FileArtifactRepository(File location, IProvisioningAgent agent, Supplier<Iterator<IArtifactDescriptor>> descriptorSupplier) {
            super(agent, location.getName(), null, null, location.toURI(), null, null, null);
            this.descriptorSupplier = descriptorSupplier;
        }

        public IStatus getRawArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
            File artifactFile = this.getArtifactFile(descriptor);
            if (artifactFile == null) {
                return new Status(4, FileTargetDefinitionContent.class.getName(), "Artifact not found");
            }
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileInputStream inputStream = new FileInputStream(artifactFile);){
                    inputStream.transferTo(destination);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                return new Status(4, FileTargetDefinitionContent.class.getName(), "transfer failed", (Throwable)e);
            }
            return Status.OK_STATUS;
        }

        public IQueryable<IArtifactDescriptor> descriptorQueryable() {
            return new IQueryable<IArtifactDescriptor>(){

                public IQueryResult<IArtifactDescriptor> query(IQuery<IArtifactDescriptor> query, IProgressMonitor monitor) {
                    return query.perform(descriptorSupplier.get());
                }
            };
        }

        public IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> query, IProgressMonitor monitor) {
            final Iterator<IArtifactDescriptor> iterator = this.descriptorSupplier.get();
            return query.perform((Iterator)new Iterator<IArtifactKey>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public IArtifactKey next() {
                    IArtifactDescriptor next = (IArtifactDescriptor)iterator.next();
                    return next.getArtifactKey();
                }
            });
        }

        public boolean contains(IArtifactDescriptor descriptor) {
            Iterator<IArtifactDescriptor> iterator = this.descriptorSupplier.get();
            while (iterator.hasNext()) {
                IArtifactDescriptor thisArtifactDescriptor = iterator.next();
                if (!thisArtifactDescriptor.equals(descriptor)) continue;
                return true;
            }
            return false;
        }

        public boolean contains(IArtifactKey key) {
            Iterator<IArtifactDescriptor> iterator = this.descriptorSupplier.get();
            while (iterator.hasNext()) {
                IArtifactDescriptor descriptor = iterator.next();
                if (!FileTargetDefinitionContent.matches(key, descriptor)) continue;
                return true;
            }
            return false;
        }

        public IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
            return this.getRawArtifact(descriptor, destination, monitor);
        }

        public IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
            Iterator<IArtifactDescriptor> iterator = this.descriptorSupplier.get();
            while (iterator.hasNext()) {
                IArtifactDescriptor descriptor = iterator.next();
                if (!FileTargetDefinitionContent.matches(key, descriptor)) continue;
                return new IArtifactDescriptor[]{descriptor};
            }
            return new IArtifactDescriptor[0];
        }

        public IStatus getArtifacts(IArtifactRequest[] requests, IProgressMonitor monitor) {
            SubMonitor convert = SubMonitor.convert((IProgressMonitor)monitor, (int)requests.length);
            MultiStatus multiStatus = new MultiStatus(FileTargetDefinitionContent.class.getName(), 1, "Request Status");
            boolean ok = true;
            IArtifactRequest[] iArtifactRequestArray = requests;
            int n = requests.length;
            int n2 = 0;
            while (n2 < n) {
                IArtifactRequest request = iArtifactRequestArray[n2];
                request.perform((IArtifactRepository)this, (IProgressMonitor)convert.split(1));
                IStatus result = request.getResult();
                multiStatus.add(result);
                ok &= result.isOK();
                ++n2;
            }
            return ok ? Status.OK_STATUS : multiStatus;
        }

        public OutputStream getOutputStream(IArtifactDescriptor descriptor) throws ProvisionException {
            throw new ProvisionException("read only");
        }

        public File getArtifactFile(IArtifactKey key) {
            Iterator<IArtifactDescriptor> iterator = this.descriptorSupplier.get();
            while (iterator.hasNext()) {
                IArtifactDescriptor descriptor = iterator.next();
                if (!FileTargetDefinitionContent.matches(key, descriptor)) continue;
                return this.getArtifactFile(descriptor);
            }
            return null;
        }

        public File getArtifactFile(IArtifactDescriptor descriptor) {
            if (descriptor instanceof FileArtifactDescriptor) {
                return ((FileArtifactDescriptor)descriptor).file;
            }
            return null;
        }
    }

    private static class FileMetadataRepository
    extends AbstractMetadataRepository {
        private Supplier<Iterator<IInstallableUnit>> unitprovider;

        public FileMetadataRepository(File location, IProvisioningAgent agent, Supplier<Iterator<IInstallableUnit>> unitprovider) {
            super(agent);
            this.unitprovider = unitprovider;
            this.setLocation(location.toURI());
        }

        public Collection<IRepositoryReference> getReferences() {
            return Collections.emptyList();
        }

        public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
            return query.perform(this.unitprovider.get());
        }

        public void initialize(AbstractMetadataRepository.RepositoryState state) {
        }
    }
}

