/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.remote;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.repository.CacheManager;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.MavenLogger;

class RemoteRepositoryCacheManager
extends CacheManager {
    public static final String CACHE_RELPATH = ".cache/tycho/p2-repository-metadata";
    private final boolean offline;
    private final File localRepositoryLocation;
    private final MavenLogger logger;

    public RemoteRepositoryCacheManager(Transport transport, MavenContext mavenContext) {
        super(null, transport);
        this.localRepositoryLocation = mavenContext.getLocalRepositoryRoot();
        this.offline = mavenContext.isOffline();
        this.logger = mavenContext.getLogger();
        if (this.logger == null) {
            throw new NullPointerException();
        }
    }

    public File createCache(URI repositoryLocation, String prefix, IProgressMonitor monitor) throws IOException, ProvisionException {
        File cacheFile = this.getCache(repositoryLocation, prefix);
        if (this.offline) {
            if (cacheFile != null) {
                return cacheFile;
            }
            throw new ProvisionException((IStatus)this.getFailureStatus(repositoryLocation));
        }
        try {
            return super.createCache(repositoryLocation, prefix, monitor);
        }
        catch (IOException e) {
            return this.handleCreateCacheException(cacheFile, repositoryLocation, e);
        }
        catch (ProvisionException e) {
            return this.handleCreateCacheException(cacheFile, repositoryLocation, e);
        }
    }

    public File createCacheFromFile(URI remoteFile, IProgressMonitor monitor) throws ProvisionException, IOException {
        if (this.offline) {
            File cacheFile = this.getCacheFile(remoteFile);
            if (cacheFile != null) {
                return cacheFile;
            }
            throw new ProvisionException((IStatus)this.getFailureStatus(remoteFile));
        }
        return super.createCacheFromFile(remoteFile, monitor);
    }

    private Status getFailureStatus(URI uri) throws ProvisionException {
        return new Status(4, "org.eclipse.tycho.p2.impl", 1000, "Repository system is offline and no local cache available for " + uri.toString(), null);
    }

    private File getCacheFile(URI url) {
        File dataAreaFile = this.getCacheDirectory();
        int hashCode = url.hashCode();
        return new File(dataAreaFile, Integer.toString(hashCode));
    }

    private <T extends Exception> File handleCreateCacheException(File cacheFile, URI repositoryLocation, T e) throws T {
        if (cacheFile != null) {
            String message = "Failed to access p2 repository " + repositoryLocation.toASCIIString() + ", use local cache.";
            if (this.logger.isDebugEnabled()) {
                this.logger.warn(message, e);
            } else {
                message = String.valueOf(message) + " " + e.getMessage();
                this.logger.warn(message);
            }
            return cacheFile;
        }
        throw e;
    }

    protected File getCacheDirectory() {
        return new File(this.localRepositoryLocation, CACHE_RELPATH);
    }
}

