/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.resolver;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.equinox.internal.p2.director.PermissiveSlicer;
import org.eclipse.equinox.internal.p2.director.Slicer;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.p2.impl.resolver.AbstractSlicerResolutionStrategy;
import org.eclipse.tycho.p2.impl.resolver.ResolverDebugUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlicerResolutionStrategy
extends AbstractSlicerResolutionStrategy {
    public SlicerResolutionStrategy(MavenLogger logger) {
        super(logger);
    }

    @Override
    protected Slicer newSlicer(IQueryable<IInstallableUnit> availableIUs, Map<String, String> properties) {
        return new PermissiveSlicer(availableIUs, properties, true, false, this.ignoreFilters(), this.strictDependencies(), false);
    }

    @Override
    protected boolean isSlicerError(MultiStatus slicerStatus) {
        return slicerStatus.matches(14);
    }

    @Override
    public Collection<IInstallableUnit> resolve(Map<String, String> properties, IProgressMonitor monitor) {
        properties = this.addFeatureJarFilter(properties);
        IQueryable<IInstallableUnit> slice = this.slice(properties, monitor);
        LinkedHashSet<IInstallableUnit> result = new LinkedHashSet<IInstallableUnit>(slice.query(QueryUtil.ALL_UNITS, monitor).toUnmodifiableSet());
        result.removeAll(this.jreIUs);
        if (this.logger.isExtendedDebugEnabled()) {
            this.logger.debug("Resolved IUs:\n" + ResolverDebugUtils.toDebugString(result, false));
        }
        return result;
    }

    protected boolean ignoreFilters() {
        return true;
    }

    protected boolean strictDependencies() {
        return true;
    }
}

