/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.tycho.PlatformPropertiesUtils;

public final class TargetEnvironment {
    private static final String OSGI_OS = "osgi.os";
    private static final String OSGI_WS = "osgi.ws";
    private static final String OSGI_ARCH = "osgi.arch";
    private String os;
    private String ws;
    private String arch;

    public TargetEnvironment() {
    }

    public TargetEnvironment(String os, String ws, String arch) {
        this.os = os;
        this.ws = ws;
        this.arch = arch;
    }

    public String getOs() {
        return this.os;
    }

    public String getWs() {
        return this.ws;
    }

    public String getArch() {
        return this.arch;
    }

    public boolean match(String os, String ws, String arch) {
        return !(os != null && !os.equals(this.os) || ws != null && !ws.equals(this.ws) || arch != null && !arch.equals(this.arch));
    }

    public String toConfigSpec() {
        return String.valueOf(this.ws) + '.' + this.os + '.' + this.arch;
    }

    public HashMap<String, String> toFilterProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.os != null) {
            result.put(OSGI_OS, this.os);
        }
        if (this.ws != null) {
            result.put(OSGI_WS, this.ws);
        }
        if (this.arch != null) {
            result.put(OSGI_ARCH, this.arch);
        }
        return result;
    }

    public String toFilterExpression() {
        ArrayList<String> conditions = new ArrayList<String>();
        if (this.os != null) {
            conditions.add("osgi.os=" + this.os);
        }
        if (this.ws != null) {
            conditions.add("osgi.ws=" + this.ws);
        }
        if (this.arch != null) {
            conditions.add("osgi.arch=" + this.arch);
        }
        if (conditions.isEmpty()) {
            return null;
        }
        if (conditions.size() == 1) {
            return "(" + (String)conditions.get(0) + ")";
        }
        StringBuilder result = new StringBuilder("(&");
        for (String condition : conditions) {
            result.append(" (").append(condition).append(")");
        }
        result.append(" )");
        return result.toString();
    }

    public String toString() {
        return String.valueOf(this.os) + '/' + this.ws + '/' + this.arch;
    }

    public int hashCode() {
        int hash = 17;
        hash = 17 * hash + (this.os != null ? this.os.hashCode() : 0);
        hash = 17 * hash + (this.ws != null ? this.ws.hashCode() : 0);
        hash = 17 * hash + (this.arch != null ? this.arch.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TargetEnvironment)) {
            return false;
        }
        TargetEnvironment other = (TargetEnvironment)obj;
        return TargetEnvironment.eq(this.os, other.os) && TargetEnvironment.eq(this.ws, other.ws) && TargetEnvironment.eq(this.arch, other.arch);
    }

    private static boolean eq(String a, String b) {
        return a != null ? a.equals(b) : b == null;
    }

    public static TargetEnvironment getRunningEnvironment() {
        Properties properties = new Properties();
        properties.put(OSGI_OS, PlatformPropertiesUtils.getOS(properties));
        properties.put(OSGI_WS, PlatformPropertiesUtils.getWS(properties));
        properties.put(OSGI_ARCH, PlatformPropertiesUtils.getArch(properties));
        return new TargetEnvironment(properties.getProperty(OSGI_OS), properties.getProperty(OSGI_WS), properties.getProperty(OSGI_ARCH));
    }
}

