/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho;

import java.io.File;
import java.util.Objects;
import org.eclipse.tycho.BuildDirectory;
import org.eclipse.tycho.BuildProperties;
import org.eclipse.tycho.BuildPropertiesParser;
import org.eclipse.tycho.IDependencyMetadata;
import org.eclipse.tycho.Interpolator;
import org.eclipse.tycho.ReactorProjectIdentities;

public interface ReactorProject
extends IDependencyMetadata {
    public static final String CTX_INTERPOLATOR = "tycho.project.interpolator";
    public static final String CTX_BUILDPROPERTIESPARSER = "tycho.project.buildpropertiesparser";
    public static final String SOURCE_ARTIFACT_CLASSIFIER = "sources";

    public File getBasedir();

    public String getPackaging();

    public String getGroupId();

    public String getArtifactId();

    public String getVersion();

    public ReactorProjectIdentities getIdentities();

    public BuildDirectory getBuildDirectory();

    public File getArtifact();

    public File getArtifact(String var1);

    public Object getContextValue(String var1);

    public void setContextValue(String var1, Object var2);

    public String getBuildQualifier();

    public String getExpandedVersion();

    default public Interpolator getInterpolator() {
        return Objects.requireNonNull((Interpolator)this.getContextValue(CTX_INTERPOLATOR), "No Interpolator found, has the TychoMavenLifecycleParticipant not run?");
    }

    default public BuildProperties getBuildProperties() {
        BuildPropertiesParser parser = Objects.requireNonNull((BuildPropertiesParser)this.getContextValue(CTX_BUILDPROPERTIESPARSER), "No BuildPropertiesParser found, has the TychoMavenLifecycleParticipant not run?");
        return parser.parse(this);
    }

    public String getId();

    public boolean sameProject(Object var1);

    public String getName();

    public <T> T adapt(Class<T> var1);
}

