/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.extras.eclipserun;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.sisu.equinox.launching.DefaultEquinoxInstallationDescription;
import org.eclipse.sisu.equinox.launching.EquinoxInstallation;
import org.eclipse.sisu.equinox.launching.EquinoxInstallationDescription;
import org.eclipse.sisu.equinox.launching.EquinoxInstallationFactory;
import org.eclipse.sisu.equinox.launching.EquinoxLauncher;
import org.eclipse.sisu.equinox.launching.internal.EquinoxLaunchConfiguration;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.artifacts.IllegalArtifactReferenceException;
import org.eclipse.tycho.artifacts.TargetPlatform;
import org.eclipse.tycho.core.ee.ExecutionEnvironmentConfigurationImpl;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.core.maven.ToolchainProvider;
import org.eclipse.tycho.core.resolver.shared.MavenRepositoryLocation;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.launching.LaunchConfiguration;
import org.eclipse.tycho.osgi.adapters.MavenLoggerAdapter;
import org.eclipse.tycho.p2.resolver.facade.P2ResolutionResult;
import org.eclipse.tycho.p2.resolver.facade.P2Resolver;
import org.eclipse.tycho.p2.resolver.facade.P2ResolverFactory;
import org.eclipse.tycho.p2.target.facade.TargetPlatformConfigurationStub;
import org.eclipse.tycho.plugins.p2.extras.Repository;

@Mojo(name="eclipse-run")
public class EclipseRunMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/eclipserun-work")
    private File work;
    @Parameter(property="project")
    private MavenProject project;
    @Parameter
    private List<Dependency> dependencies = new ArrayList<Dependency>();
    @Parameter(defaultValue="true")
    private boolean addDefaultDependencies;
    @Parameter(defaultValue="JavaSE-11")
    private String executionEnvironment;
    @Parameter(required=true)
    private List<Repository> repositories;
    @Parameter(property="session", readonly=true, required=true)
    private MavenSession session;
    @Parameter
    private String argLine;
    @Parameter
    private List<String> jvmArgs;
    @Parameter(property="eclipserun.skip", defaultValue="false")
    private boolean skip;
    @Parameter
    private String appArgLine;
    @Parameter
    private List<String> applicationsArgs;
    @Parameter(property="eclipserun.timeout")
    private int forkedProcessTimeoutInSeconds;
    @Parameter
    private Map<String, String> environmentVariables;
    @Component
    private EquinoxInstallationFactory installationFactory;
    @Component
    private EquinoxLauncher launcher;
    @Component
    private ToolchainProvider toolchainProvider;
    @Component
    private EquinoxServiceFactory equinox;
    @Component
    private Logger logger;
    @Component
    private ToolchainManager toolchainManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"skipping mojo execution");
            return;
        }
        EquinoxInstallation installation = this.createEclipseInstallation();
        this.runEclipse(installation);
    }

    private void addDefaultDependency(P2Resolver resolver, String bundleId) {
        try {
            resolver.addDependency("eclipse-plugin", bundleId, null);
        }
        catch (IllegalArtifactReferenceException e) {
            throw new RuntimeException(e);
        }
    }

    private void addDefaultDependencies(P2Resolver resolver) {
        if (this.addDefaultDependencies) {
            this.addDefaultDependency(resolver, "org.eclipse.osgi");
            this.addDefaultDependency(resolver, "org.eclipse.equinox.launcher");
            this.addDefaultDependency(resolver, "org.eclipse.core.runtime");
        }
    }

    private EquinoxInstallation createEclipseInstallation() throws MojoFailureException {
        P2ResolverFactory resolverFactory = (P2ResolverFactory)this.equinox.getService(P2ResolverFactory.class);
        TargetPlatformConfigurationStub tpConfiguration = new TargetPlatformConfigurationStub();
        tpConfiguration.setForceIgnoreLocalArtifacts(true);
        for (Repository repository : this.repositories) {
            tpConfiguration.addP2Repository(new MavenRepositoryLocation(repository.getId(), repository.getLocation()));
        }
        ExecutionEnvironmentConfigurationImpl eeConfiguration = new ExecutionEnvironmentConfigurationImpl(this.logger, false, this.toolchainManager, this.session);
        TargetPlatform targetPlatform = resolverFactory.getTargetPlatformFactory().createTargetPlatform(tpConfiguration, (ExecutionEnvironmentConfiguration)eeConfiguration, null, null);
        P2Resolver resolver = resolverFactory.createResolver((MavenLogger)new MavenLoggerAdapter(this.logger, false));
        for (Dependency dependency : this.dependencies) {
            try {
                resolver.addDependency(dependency.getType(), dependency.getArtifactId(), dependency.getVersion());
            }
            catch (IllegalArtifactReferenceException e) {
                throw new MojoFailureException("Invalid dependency " + dependency.getType() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        this.addDefaultDependencies(resolver);
        DefaultEquinoxInstallationDescription installationDesc = new DefaultEquinoxInstallationDescription();
        for (P2ResolutionResult result : resolver.resolveDependencies(targetPlatform, null)) {
            for (P2ResolutionResult.Entry entry : result.getArtifacts()) {
                if (!"eclipse-plugin".equals(entry.getType())) continue;
                installationDesc.addBundle((ArtifactKey)new DefaultArtifactKey("eclipse-plugin", entry.getId(), entry.getVersion()), entry.getLocation());
            }
        }
        return this.installationFactory.createInstallation((EquinoxInstallationDescription)installationDesc, this.work);
    }

    private void runEclipse(EquinoxInstallation runtime) throws MojoExecutionException, MojoFailureException {
        try {
            File workspace = new File(this.work, "data").getAbsoluteFile();
            FileUtils.deleteDirectory((File)workspace);
            LaunchConfiguration cli = this.createCommandLine(runtime);
            this.getLog().info((CharSequence)("Expected eclipse log file: " + new File(workspace, ".metadata/.log").getCanonicalPath()));
            int returnCode = this.launcher.execute(cli, this.forkedProcessTimeoutInSeconds);
            if (returnCode != 0) {
                throw new MojoExecutionException("Error while executing platform (return code: " + returnCode + ")");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while executing platform", e);
        }
    }

    LaunchConfiguration createCommandLine(EquinoxInstallation runtime) throws MalformedURLException, MojoExecutionException {
        EquinoxLaunchConfiguration cli = new EquinoxLaunchConfiguration(runtime);
        String executable = null;
        Toolchain tc = this.getToolchain();
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in tycho-eclipserun-plugin: " + tc));
            executable = tc.findTool("java");
        }
        cli.setJvmExecutable(executable);
        cli.setWorkingDirectory(this.project.getBasedir());
        cli.addVMArguments(this.splitArgLine(this.argLine));
        if (this.jvmArgs != null) {
            cli.addVMArguments(this.jvmArgs.toArray(new String[this.jvmArgs.size()]));
        }
        this.addProgramArgs(cli, "-install", runtime.getLocation().getAbsolutePath(), "-configuration", new File(this.work, "configuration").getAbsolutePath());
        cli.addProgramArguments(this.splitArgLine(this.appArgLine));
        if (this.applicationsArgs != null) {
            for (String args : this.applicationsArgs) {
                cli.addProgramArguments(this.splitArgLine(args));
            }
        }
        if (this.environmentVariables != null) {
            cli.addEnvironmentVariables(this.environmentVariables);
        }
        return cli;
    }

    private String[] splitArgLine(String argumentLine) throws MojoExecutionException {
        try {
            return CommandLineUtils.translateCommandline((String)argumentLine);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error parsing commandline: " + e.getMessage(), e);
        }
    }

    private void addProgramArgs(EquinoxLaunchConfiguration cli, String ... arguments) {
        if (arguments != null) {
            for (String argument : arguments) {
                if (argument == null) continue;
                cli.addProgramArguments(new String[]{argument});
            }
        }
    }

    private Toolchain getToolchain() throws MojoExecutionException {
        return this.toolchainProvider.findMatchingJavaToolChain(this.session, this.executionEnvironment);
    }
}

