/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.maven.action;

import aQute.bnd.osgi.EmbeddedResource;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.ManifestResource;
import aQute.bnd.osgi.Resource;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.jar.Manifest;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.action.Action;
import org.eclipse.transformer.action.ActionContext;
import org.eclipse.transformer.action.ActionSelector;
import org.eclipse.transformer.action.ActionType;
import org.eclipse.transformer.action.ByteData;
import org.eclipse.transformer.action.Changes;
import org.eclipse.transformer.action.ElementAction;
import org.eclipse.transformer.action.impl.ByteDataImpl;
import org.eclipse.transformer.action.impl.ContainerActionImpl;
import org.eclipse.transformer.maven.action.TransformerJarChanges;

public class TransformerJarAction
extends ContainerActionImpl {
    private final boolean overwrite;

    public TransformerJarAction(ActionContext context, ActionSelector selector, boolean overwrite) {
        super(context, selector);
        this.overwrite = overwrite;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public String getName() {
        return "Transformer Maven Plugin Action";
    }

    public ActionType getActionType() {
        return ActionType.JAR;
    }

    protected TransformerJarChanges newChanges() {
        return new TransformerJarChanges();
    }

    public TransformerJarChanges getActiveChanges() {
        return (TransformerJarChanges)super.getActiveChanges();
    }

    public TransformerJarChanges getLastActiveChanges() {
        return (TransformerJarChanges)super.getLastActiveChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(Jar jar, String inputName, String outputName) {
        String manifestName = jar.getManifestName();
        this.startRecording(inputName);
        try {
            this.setResourceNames(inputName, outputName);
            Map resources = jar.getResources();
            ArrayList<String> inputPaths = new ArrayList<String>(resources.size() + 1);
            if (!resources.containsKey(manifestName)) {
                inputPaths.add(manifestName);
            }
            inputPaths.addAll(resources.keySet());
            for (String inputPath : inputPaths) {
                Action action = this.selectAction(inputPath);
                if (action == null) {
                    this.recordUnaccepted(inputPath);
                    continue;
                }
                if (!this.selectResource(inputPath)) {
                    this.recordUnselected(inputPath);
                    continue;
                }
                if (!action.isElementAction()) {
                    this.getLogger().warn("Strange non-element action [ {} ] for [ {} ]: Ignoring", (Object)action.getClass().getName(), (Object)inputPath);
                    this.recordUnaccepted(inputPath);
                    continue;
                }
                try {
                    ByteData inputData;
                    ByteBuffer bb;
                    Resource resource = jar.getResource(inputPath);
                    if (inputPath.equals(manifestName) && resource == null) {
                        Manifest manifest = jar.getManifest();
                        if (manifest == null) continue;
                        resource = new ManifestResource(manifest);
                    }
                    if ((bb = resource.buffer()) != null) {
                        Charset charset = this.resourceCharset(inputPath);
                        inputData = new ByteDataImpl(inputPath, bb, charset);
                    } else {
                        inputData = this.collect(inputPath, resource.openInputStream(), Math.toIntExact(resource.size()));
                    }
                    ByteData outputData = ((ElementAction)action).apply(inputData);
                    this.recordAction(action, inputPath);
                    Changes changes = action.getLastActiveChanges();
                    if (!changes.isChanged()) continue;
                    String outputPath = outputData.name();
                    this.getLogger().debug("[ {}.apply ]: Active transform [ {} ] [ {} ]", new Object[]{action.getClass().getSimpleName(), inputPath, outputPath});
                    if (changes.isRenamed()) {
                        if (!this.isOverwrite() && jar.getResource(outputPath) != null) {
                            this.recordDuplicate(action, inputPath);
                            this.getLogger().error("Transform for {} overwrites existing resource {}. Use 'overwrite' option to allow overwriting.", (Object)inputPath, (Object)outputPath);
                            continue;
                        }
                        jar.remove(inputPath);
                        this.getActiveChanges().addRemoved(inputPath);
                    }
                    Resource outputResource = changes.isContentChanged() ? new EmbeddedResource(outputData.buffer(), resource.lastModified()) : resource;
                    jar.putResource(outputPath, outputResource);
                    this.getActiveChanges().addChanged(outputPath);
                }
                catch (Exception e) {
                    this.getLogger().error("Failure while transforming {}", (Object)inputPath, (Object)e);
                    this.recordError(action, inputPath, e);
                }
            }
        }
        finally {
            this.stopRecording(inputName);
        }
    }

    public void apply(String inputName, File inputFile, String outputName, File outputFile) throws TransformException {
        throw new UnsupportedOperationException();
    }
}

