/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;

public class URLTransfer
extends ByteArrayTransfer {
    static URLTransfer _instance = new URLTransfer();
    static final String CFSTR_INETURLW = "UniformResourceLocatorW";
    static final int CFSTR_INETURLIDW = URLTransfer.registerType("UniformResourceLocatorW");
    static final String CFSTR_INETURL = "UniformResourceLocator";
    static final int CFSTR_INETURLID = URLTransfer.registerType("UniformResourceLocator");

    private URLTransfer() {
    }

    public static URLTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkURL(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.result = -2147467259;
        String string = (String)object;
        if (transferData.type == CFSTR_INETURLIDW) {
            int n = string.length();
            char[] cArray = new char[n + 1];
            string.getChars(0, n, cArray, 0);
            int n2 = cArray.length * 2;
            int n3 = OS.GlobalAlloc(64, n2);
            OS.MoveMemory(n3, cArray, n2);
            transferData.stgmedium = new STGMEDIUM();
            transferData.stgmedium.tymed = 1;
            transferData.stgmedium.unionField = n3;
            transferData.stgmedium.pUnkForRelease = 0;
            transferData.result = 0;
        } else if (transferData.type == CFSTR_INETURLID) {
            int n = string.length();
            char[] cArray = new char[n + 1];
            string.getChars(0, n, cArray, 0);
            int n4 = OS.GetACP();
            int n5 = OS.WideCharToMultiByte(n4, 0, cArray, -1, null, 0, null, null);
            if (n5 == 0) {
                transferData.stgmedium = new STGMEDIUM();
                transferData.result = -2147221402;
                return;
            }
            int n6 = OS.GlobalAlloc(64, n5);
            OS.WideCharToMultiByte(n4, 0, cArray, -1, n6, n5, null, null);
            transferData.stgmedium = new STGMEDIUM();
            transferData.stgmedium.tymed = 1;
            transferData.stgmedium.unionField = n6;
            transferData.stgmedium.pUnkForRelease = 0;
            transferData.result = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData)) return null;
        if (transferData.pIDataObject == 0) {
            return null;
        }
        IDataObject iDataObject = new IDataObject(transferData.pIDataObject);
        iDataObject.AddRef();
        STGMEDIUM sTGMEDIUM = new STGMEDIUM();
        FORMATETC fORMATETC = transferData.formatetc;
        sTGMEDIUM.tymed = 1;
        transferData.result = this.getData(iDataObject, fORMATETC, sTGMEDIUM);
        iDataObject.Release();
        if (transferData.result != 0) {
            return null;
        }
        int n = sTGMEDIUM.unionField;
        try {
            if (transferData.type == CFSTR_INETURLIDW) {
                String string;
                int n2 = OS.GlobalSize(n) / 2 * 2;
                if (n2 == 0) {
                    Object var7_8 = null;
                    Object var16_12 = null;
                    OS.GlobalFree(n);
                    return var7_8;
                }
                char[] cArray = new char[n2 / 2];
                int n3 = OS.GlobalLock(n);
                if (n3 == 0) {
                    Object var9_22 = null;
                    Object var16_13 = null;
                    OS.GlobalFree(n);
                    return var9_22;
                }
                try {
                    OS.MoveMemory(cArray, n3, n2);
                    int n4 = cArray.length;
                    for (int i = 0; i < cArray.length; ++i) {
                        if (cArray[i] != '\u0000') continue;
                        n4 = i;
                        break;
                    }
                    string = new String(cArray, 0, n4);
                    Object var12_29 = null;
                }
                catch (Throwable throwable) {
                    Object var12_30 = null;
                    OS.GlobalUnlock(n);
                    throw throwable;
                }
                OS.GlobalUnlock(n);
                Object var16_14 = null;
                OS.GlobalFree(n);
                return string;
            }
            if (transferData.type == CFSTR_INETURLID) {
                int n5;
                int n6;
                int n7;
                block15: {
                    Object var9_24;
                    n7 = OS.GlobalLock(n);
                    if (n7 == 0) {
                        Object var7_10 = null;
                        Object var16_15 = null;
                        OS.GlobalFree(n);
                        return var7_10;
                    }
                    try {
                        n6 = OS.GetACP();
                        n5 = OS.MultiByteToWideChar(n6, 1, n7, -1, null, 0);
                        if (n5 != 0) break block15;
                        var9_24 = null;
                        Object var14_32 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_34 = null;
                        OS.GlobalUnlock(n);
                        throw throwable;
                    }
                    OS.GlobalUnlock(n);
                    Object var16_16 = null;
                    OS.GlobalFree(n);
                    return var9_24;
                }
                char[] cArray = new char[n5 - 1];
                OS.MultiByteToWideChar(n6, 1, n7, -1, cArray, cArray.length);
                String string = new String(cArray);
                Object var14_33 = null;
                OS.GlobalUnlock(n);
                Object var16_17 = null;
                OS.GlobalFree(n);
                return string;
            }
            Object var16_18 = null;
            OS.GlobalFree(n);
            return null;
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            OS.GlobalFree(n);
            throw throwable;
        }
    }

    protected int[] getTypeIds() {
        return new int[]{CFSTR_INETURLIDW, CFSTR_INETURLID};
    }

    protected String[] getTypeNames() {
        return new String[]{CFSTR_INETURLW, CFSTR_INETURL};
    }

    boolean checkURL(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkURL(object);
    }
}

