/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import java.net.URL;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.sisu.inject.DeferredClass;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.plexus.ComponentImpl;
import org.eclipse.sisu.plexus.Hints;
import org.eclipse.sisu.plexus.PlexusTypeListener;
import org.eclipse.sisu.space.AnnotationVisitor;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.ClassSpaceVisitor;
import org.eclipse.sisu.space.ClassVisitor;
import org.eclipse.sisu.space.LoadedClass;
import org.eclipse.sisu.space.QualifiedTypeListener;
import org.eclipse.sisu.space.QualifiedTypeVisitor;

public final class PlexusTypeVisitor
implements ClassSpaceVisitor,
ClassVisitor {
    private static final String COMPONENT_DESC = 'L' + Component.class.getName().replace('.', '/') + ';';
    private final ComponentAnnotationVisitor componentVisitor = new ComponentAnnotationVisitor();
    private final PlexusTypeListener plexusTypeListener;
    private final QualifiedTypeVisitor qualifiedTypeVisitor;
    private ClassSpace space;
    private String source;
    private String implementation;

    public PlexusTypeVisitor(PlexusTypeListener listener) {
        this.plexusTypeListener = listener;
        this.qualifiedTypeVisitor = new QualifiedTypeVisitor((QualifiedTypeListener)listener);
    }

    public void enter(ClassSpace _space) {
        this.space = _space;
        this.source = _space.toString();
        this.qualifiedTypeVisitor.enter(_space);
        if (Logs.TRACE_ENABLED) {
            QualifiedTypeVisitor.verify((ClassSpace)_space, (Class[])new Class[]{Component.class});
        }
    }

    public ClassVisitor visitClass(URL url) {
        this.componentVisitor.reset();
        this.implementation = null;
        this.qualifiedTypeVisitor.visitClass(url);
        return this;
    }

    public void enter(int modifiers, String name, String _extends, String[] _implements) {
        if ((modifiers & 0x7600) == 0) {
            this.implementation = name.replace('/', '.');
        }
        this.qualifiedTypeVisitor.enter(modifiers, name, _extends, _implements);
    }

    public AnnotationVisitor visitAnnotation(String desc) {
        if (COMPONENT_DESC.equals(desc)) {
            return this.componentVisitor;
        }
        return this.qualifiedTypeVisitor.visitAnnotation(desc);
    }

    public void leave() {
        if (null != this.implementation) {
            Component component = this.componentVisitor.getComponent(this.space);
            if (null != component) {
                LoadedClass clazz = new LoadedClass(this.space.loadClass(this.implementation));
                this.plexusTypeListener.hear(component, (DeferredClass<?>)clazz, this.source);
            } else {
                this.qualifiedTypeVisitor.leave();
            }
            this.implementation = null;
        }
    }

    static final class ComponentAnnotationVisitor
    implements AnnotationVisitor {
        private String role;
        private String hint;
        private String strategy;
        private String description;

        ComponentAnnotationVisitor() {
        }

        public void reset() {
            this.role = null;
            this.hint = "default";
            this.strategy = "singleton";
            this.description = "";
        }

        public void enter() {
        }

        public void visitElement(String name, Object value) {
            if ("role".equals(name)) {
                this.role = (String)value;
            } else if ("hint".equals(name)) {
                this.hint = Hints.canonicalHint((String)value);
            } else if ("instantiationStrategy".equals(name)) {
                this.strategy = (String)value;
            } else if ("description".equals(name)) {
                this.description = (String)value;
            }
        }

        public void leave() {
        }

        public Component getComponent(ClassSpace space) {
            return null != this.role ? new ComponentImpl(space.loadClass(this.role), this.hint, this.strategy, this.description) : null;
        }
    }
}

