/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import com.google.inject.TypeLiteral;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.ParameterizedConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.eclipse.sisu.reflect.BeanProperties;
import org.eclipse.sisu.reflect.BeanProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BeanHelper {
    private static final Type[] NO_TYPES = new Type[0];
    private final ConverterLookup lookup;
    private final ClassLoader loader;
    private final ExpressionEvaluator evaluator;
    private final ConfigurationListener listener;

    BeanHelper(ConverterLookup lookup, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) {
        this.lookup = lookup;
        this.loader = loader;
        this.evaluator = evaluator;
        this.listener = listener;
    }

    void setDefault(Object bean, Object defaultValue, PlexusConfiguration configuration) throws ComponentConfigurationException {
        Class<?> beanType = bean.getClass();
        for (Method method : beanType.getMethods()) {
            Class<?>[] parameterTypes;
            if (!"set".equals(method.getName()) || Modifier.isStatic(method.getModifiers()) || (parameterTypes = method.getParameterTypes()).length != 1) continue;
            Class<?> type = parameterTypes[0];
            Object value = defaultValue;
            if (!type.isInstance(value)) {
                if (configuration.getChildCount() > 0) {
                    throw new ComponentConfigurationException("Basic element '" + configuration.getName() + "' must not contain child elements");
                }
                value = this.convertProperty(beanType, type, type, configuration);
            }
            if (null != this.listener) {
                this.listener.notifyFieldChangeUsingSetter("", value, bean);
            }
            try {
                method.invoke(bean, value);
                return;
            }
            catch (Exception e) {
                throw new ComponentConfigurationException(configuration, "Cannot set default", e);
            }
            catch (LinkageError e) {
                throw new ComponentConfigurationException(configuration, "Cannot set default", e);
            }
        }
        throw new ComponentConfigurationException(configuration, "Cannot find default setter in " + beanType);
    }

    void setProperty(Object bean, String propertyName, Class<?> implType, PlexusConfiguration configuration) throws ComponentConfigurationException {
        boolean foundProperty = false;
        Class<?> beanType = bean.getClass();
        ComponentConfigurationException problem = null;
        Object value = null;
        for (BeanProperty property : new BeanProperties(beanType)) {
            if (!propertyName.equals(property.getName())) continue;
            foundProperty = true;
            TypeLiteral propertyType = property.getType();
            Class<?> rawPropertyType = propertyType.getRawType();
            try {
                if (!rawPropertyType.isInstance(value)) {
                    if (null != implType && rawPropertyType.isAssignableFrom(implType)) {
                        rawPropertyType = implType;
                    }
                    value = this.convertProperty(beanType, rawPropertyType, propertyType.getType(), configuration);
                }
                if (null == value) continue;
                if (null != this.listener) {
                    this.listener.notifyFieldChangeUsingReflection(propertyName, value, bean);
                }
                property.set(bean, value);
                return;
            }
            catch (ComponentConfigurationException e) {
                if (null != problem) continue;
                problem = e;
            }
        }
        if (null != problem) {
            throw problem;
        }
        if (!foundProperty) {
            throw new ComponentConfigurationException(configuration, "Cannot find '" + propertyName + "' in " + beanType);
        }
    }

    private Object convertProperty(Class<?> beanType, Class<?> rawPropertyType, Type genericPropertyType, PlexusConfiguration configuration) throws ComponentConfigurationException {
        ConfigurationConverter converter = this.lookup.lookupConverterForType(rawPropertyType);
        if (!(genericPropertyType instanceof Class) && converter instanceof ParameterizedConfigurationConverter) {
            Type[] paramTypes = BeanHelper.getParameterTypes(genericPropertyType);
            return ((ParameterizedConfigurationConverter)converter).fromConfiguration(this.lookup, configuration, rawPropertyType, paramTypes, beanType, this.loader, this.evaluator, this.listener);
        }
        return converter.fromConfiguration(this.lookup, configuration, rawPropertyType, beanType, this.loader, this.evaluator, this.listener);
    }

    private static Type[] getParameterTypes(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] argumentTypes = ((ParameterizedType)type).getActualTypeArguments();
            for (int i = 0; i < argumentTypes.length; ++i) {
                argumentTypes[i] = BeanHelper.expandType(argumentTypes[i]);
            }
            return argumentTypes;
        }
        if (type instanceof GenericArrayType) {
            return new Type[]{BeanHelper.expandType(((GenericArrayType)type).getGenericComponentType())};
        }
        return NO_TYPES;
    }

    private static Type expandType(Type type) {
        if (type instanceof WildcardType) {
            return ((WildcardType)type).getUpperBounds()[0];
        }
        if (type instanceof TypeVariable) {
            return ((TypeVariable)type).getBounds()[0];
        }
        return type;
    }
}

