/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.sisu.space.AnnotationVisitor;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.ClassVisitor;
import org.eclipse.sisu.space.SpaceScanner;
import org.eclipse.sisu.space.Tokens;

final class QualifierCache
implements ClassVisitor {
    private static final String QUALIFIER_DESC = "Ljavax/inject/Qualifier;";
    private static final String NAMED_DESC = "Ljavax/inject/Named;";
    private static final Map<String, Boolean> cachedResults = QualifierCache.seedResults();
    private boolean isQualified;

    QualifierCache() {
    }

    @Override
    public void enterClass(int modifiers, String name, String _extends, String[] _implements) {
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc) {
        this.isQualified |= QUALIFIER_DESC.equals(desc);
        return null;
    }

    @Override
    public void leaveClass() {
    }

    boolean qualify(ClassSpace space, String desc) {
        if (NAMED_DESC.equals(desc)) {
            return true;
        }
        Boolean result = cachedResults.get(desc);
        if (result == null) {
            this.isQualified = false;
            String name = desc.substring(1, desc.length() - 1);
            SpaceScanner.accept(this, space.getResource(String.valueOf(name) + ".class"));
            cachedResults.put(desc, this.isQualified);
            return this.isQualified;
        }
        return result;
    }

    private static Map<String, Boolean> seedResults() {
        ConcurrentHashMap<String, Boolean> results = new ConcurrentHashMap<String, Boolean>(32, 0.75f, 1);
        try {
            String qualifiers = System.getProperty("sisu.qualifiers");
            if (qualifiers != null && qualifiers.length() > 0) {
                StringBuilder buf = new StringBuilder("L");
                for (String q : Tokens.splitByComma(qualifiers)) {
                    buf.append(q.replace('.', '/')).append(';');
                    results.put(buf.toString(), Boolean.TRUE);
                    buf.setLength(1);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return results;
    }
}

