/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import com.google.inject.Binding;
import com.google.inject.spi.BindingTargetVisitor;
import java.lang.reflect.Method;
import javax.inject.Inject;
import org.eclipse.sisu.Priority;
import org.eclipse.sisu.inject.ImplementationVisitor;
import org.eclipse.sisu.inject.QualifyingStrategy;
import org.eclipse.sisu.inject.RankingFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultRankingFunction
implements RankingFunction {
    private static final Method JSR250_PRIORITY_VALUE;
    private final int primaryRank;

    static {
        Method jsr250PriorityValue;
        try {
            Class<?> clazz = Priority.class.getClassLoader().loadClass("javax.annotation.Priority");
            jsr250PriorityValue = clazz.getMethod("value", new Class[0]);
        }
        catch (Exception exception) {
            jsr250PriorityValue = null;
        }
        catch (LinkageError linkageError) {
            jsr250PriorityValue = null;
        }
        JSR250_PRIORITY_VALUE = jsr250PriorityValue;
    }

    public DefaultRankingFunction(int primaryRank) {
        if (primaryRank < 0) {
            throw new IllegalArgumentException("Primary rank must be zero or more");
        }
        this.primaryRank = primaryRank;
    }

    @Inject
    public DefaultRankingFunction() {
        this(0);
    }

    @Override
    public int maxRank() {
        return this.primaryRank;
    }

    @Override
    public <T> int rank(Binding<T> binding) {
        Class implementation = (Class)binding.acceptTargetVisitor((BindingTargetVisitor)ImplementationVisitor.THIS);
        if (implementation != null) {
            Object value;
            if (JSR250_PRIORITY_VALUE != null && (value = DefaultRankingFunction.getJSR250PriorityValue(implementation)) instanceof Number) {
                return ((Number)value).intValue();
            }
            Priority priority = implementation.getAnnotation(Priority.class);
            if (priority != null) {
                return priority.value();
            }
        }
        if (QualifyingStrategy.DEFAULT_QUALIFIER.equals(QualifyingStrategy.qualify(binding.getKey()))) {
            return this.primaryRank;
        }
        return this.primaryRank + Integer.MIN_VALUE;
    }

    private static Object getJSR250PriorityValue(Class<?> clazz) {
        Object priority = clazz.getAnnotation(JSR250_PRIORITY_VALUE.getDeclaringClass());
        if (priority != null) {
            try {
                return JSR250_PRIORITY_VALUE.invoke(priority, new Object[0]);
            }
            catch (Exception exception) {
            }
            catch (LinkageError linkageError) {}
        }
        return null;
    }
}

