/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.scanners;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import org.eclipse.sisu.reflect.ClassSpace;
import org.eclipse.sisu.reflect.Logs;
import org.eclipse.sisu.reflect.Streams;
import org.eclipse.sisu.scanners.ClassFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassFinder
implements ClassFinder {
    private final boolean global;
    private final String indexName;

    protected AbstractClassFinder(boolean global, String indexName) {
        this.global = global;
        this.indexName = indexName;
    }

    @Override
    public final Enumeration<URL> findClasses(ClassSpace space) {
        ArrayList<URL> components = new ArrayList<URL>();
        HashSet<String> visited = new HashSet<String>();
        Enumeration<URL> indices = this.global ? space.getResources("META-INF/sisu/" + this.indexName) : space.findEntries("META-INF/sisu/", this.indexName, false);
        while (indices.hasMoreElements()) {
            URL url = indices.nextElement();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(Streams.open(url)));
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        URL clazz;
                        if (visited.add(line) && (clazz = space.getResource(String.valueOf(line.replace('.', '/')) + ".class")) != null) {
                            components.add(clazz);
                        }
                        line = reader.readLine();
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                Logs.warn("Problem reading: {}", url, e);
            }
        }
        return Collections.enumeration(components);
    }
}

