/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.containers;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import junit.framework.TestCase;
import org.eclipse.sisu.BeanScanning;
import org.eclipse.sisu.binders.ParameterKeys;
import org.eclipse.sisu.binders.SpaceModule;
import org.eclipse.sisu.binders.WireModule;
import org.eclipse.sisu.locators.MutableBeanLocator;
import org.eclipse.sisu.reflect.ClassSpace;
import org.eclipse.sisu.reflect.URLClassSpace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InjectedTestCase
extends TestCase
implements Module {
    private String basedir;
    @Inject
    private MutableBeanLocator locator;

    protected void setUp() throws Exception {
        Guice.createInjector((Module[])new Module[]{new WireModule(new SpaceModule(this.space(), this.scanning()), new SetUpModule())});
    }

    protected void tearDown() throws Exception {
        this.locator.clear();
    }

    public ClassSpace space() {
        return new URLClassSpace(((Object)((Object)this)).getClass().getClassLoader());
    }

    public BeanScanning scanning() {
        return BeanScanning.CACHE;
    }

    public void configure(Binder binder) {
    }

    public void configure(Properties properties) {
    }

    public final <T> T lookup(Class<T> type) {
        return this.lookup(Key.get(type));
    }

    public final <T> T lookup(Class<T> type, String name) {
        return this.lookup(type, (Annotation)Names.named((String)name));
    }

    public final <T> T lookup(Class<T> type, Class<? extends Annotation> qualifier) {
        return this.lookup(Key.get(type, qualifier));
    }

    public final <T> T lookup(Class<T> type, Annotation qualifier) {
        return this.lookup(Key.get(type, (Annotation)qualifier));
    }

    public final String getBasedir() {
        if (this.basedir == null) {
            this.basedir = System.getProperty("basedir", new File("").getAbsolutePath());
        }
        return this.basedir;
    }

    private final <T> T lookup(Key<T> key) {
        Iterator i = this.locator.locate(key).iterator();
        return i.hasNext() ? (T)((Map.Entry)i.next()).getValue() : null;
    }

    final class SetUpModule
    implements Module {
        SetUpModule() {
        }

        public void configure(Binder binder) {
            binder.install((Module)InjectedTestCase.this);
            Properties properties = new Properties();
            properties.put("basedir", InjectedTestCase.this.getBasedir());
            InjectedTestCase.this.configure(properties);
            binder.bind(ParameterKeys.PROPERTIES).toInstance((Object)properties);
            binder.requestInjection((Object)InjectedTestCase.this);
        }
    }
}

