/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.binders;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Elements;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.sisu.binders.ElementAnalyzer;
import org.eclipse.sisu.binders.LocatorWiring;
import org.eclipse.sisu.binders.Wiring;
import org.eclipse.sisu.converters.FileTypeConverter;
import org.eclipse.sisu.converters.URLTypeConverter;
import org.eclipse.sisu.scanners.analyzer.WiringFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WireModule
implements Module {
    private final Iterable<WiringFactory> extensionWiringFactories;
    private final List<Module> modules;

    public WireModule(Module ... modules) {
        this(Arrays.asList(modules));
    }

    public WireModule(List<Module> modules) {
        this(modules, Collections.emptyList());
    }

    public WireModule(List<Module> modules, Iterable<WiringFactory> extensionWiringFactories) {
        this.extensionWiringFactories = extensionWiringFactories;
        this.modules = modules;
    }

    public void configure(Binder binder) {
        ArrayList<Wiring> wiringList = new ArrayList<Wiring>();
        for (WiringFactory wiringFactory : this.extensionWiringFactories) {
            wiringList.add(wiringFactory.create(binder));
        }
        wiringList.add(this.wiring(binder));
        ElementAnalyzer analyzer = this.getAnalyzer(binder);
        for (Module m : this.modules) {
            for (Element e : Elements.getElements((Module[])new Module[]{m})) {
                e.acceptVisitor((ElementVisitor)analyzer);
            }
        }
        analyzer.apply(wiringList);
    }

    protected Wiring wiring(Binder binder) {
        binder.install((Module)new FileTypeConverter());
        binder.install((Module)new URLTypeConverter());
        return new LocatorWiring(binder);
    }

    ElementAnalyzer getAnalyzer(Binder binder) {
        return new ElementAnalyzer(binder);
    }
}

