/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.space.ClassFinder;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.ClassVisitor;
import org.eclipse.sisu.space.DefaultClassFinder;
import org.eclipse.sisu.space.SpaceVisitor;
import org.eclipse.sisu.space.Streams;
import org.eclipse.sisu.space.asm.AnnotationVisitor;
import org.eclipse.sisu.space.asm.ClassReader;
import org.eclipse.sisu.space.asm.Type;

public final class SpaceScanner {
    private static final int ASM_FLAGS = 7;
    static final ClassFinder DEFAULT_FINDER = new DefaultClassFinder();
    private final ClassFinder finder;
    private final ClassSpace space;

    public SpaceScanner(ClassFinder finder, ClassSpace space) {
        this.finder = finder;
        this.space = space;
    }

    public SpaceScanner(ClassSpace space) {
        this(DEFAULT_FINDER, space);
    }

    public void accept(SpaceVisitor visitor) {
        visitor.enterSpace(this.space);
        Enumeration<URL> result = this.finder.findClasses(this.space);
        while (result.hasMoreElements()) {
            URL url = result.nextElement();
            ClassVisitor cv = visitor.visitClass(url);
            if (cv == null) continue;
            SpaceScanner.accept(cv, url);
        }
        visitor.leaveSpace();
    }

    public static void accept(ClassVisitor visitor, URL url) {
        if (url == null) {
            return;
        }
        try {
            InputStream in = Streams.open(url);
            try {
                new ClassReader(in).accept(SpaceScanner.adapt(visitor), 7);
            }
            finally {
                in.close();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (Exception e) {
            Logs.trace("Problem scanning: {}", url, e);
        }
    }

    private static org.eclipse.sisu.space.asm.ClassVisitor adapt(final ClassVisitor _cv) {
        return _cv == null ? null : new org.eclipse.sisu.space.asm.ClassVisitor(262144){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                _cv.enterClass(access, name, superName, interfaces);
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                final org.eclipse.sisu.space.AnnotationVisitor _av = _cv.visitAnnotation(desc);
                return _av == null ? null : new AnnotationVisitor(262144){
                    {
                        super($anonymous0);
                        annotationVisitor.enterAnnotation();
                    }

                    public void visit(String name, Object value) {
                        _av.visitElement(name, value instanceof Type ? ((Type)value).getClassName() : value);
                    }

                    public void visitEnd() {
                        _av.leaveAnnotation();
                    }
                };
            }

            public void visitEnd() {
                _cv.leaveClass();
            }
        };
    }
}

