/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.PrivateBinder;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.InjectionRequest;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.PrivateElements;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderLookup;
import com.google.inject.spi.StaticInjectionRequest;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.sisu.Parameters;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.inject.RankingFunction;
import org.eclipse.sisu.inject.TypeParameters;
import org.eclipse.sisu.wire.DependencyAnalyzer;
import org.eclipse.sisu.wire.MergedProperties;
import org.eclipse.sisu.wire.StringProperties;
import org.eclipse.sisu.wire.Wiring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ElementAnalyzer
extends DefaultElementVisitor<Void> {
    private static final Key<RankingFunction> RANKING_KEY;
    private static final Key<? extends RankingFunction> LEGACY_RANKING_KEY;
    private final Set<Key<?>> localKeys = new HashSet();
    private final DependencyAnalyzer analyzer = new DependencyAnalyzer();
    private final List<ElementAnalyzer> privateAnalyzers = new ArrayList<ElementAnalyzer>();
    private final List<Map<?, ?>> properties = new ArrayList();
    private final List<String> arguments = new ArrayList<String>();
    private final Binder binder;

    static {
        Key legacyRankingKey = null;
        try {
            Class<?> legacyType = RankingFunction.class.getClassLoader().loadClass("org.sonatype.guice.bean.locators.RankingFunction");
            if (RankingFunction.class.isAssignableFrom(legacyType)) {
                legacyRankingKey = Key.get(legacyType);
            }
        }
        catch (Exception exception) {
        }
        catch (LinkageError linkageError) {}
        LEGACY_RANKING_KEY = legacyRankingKey;
        RANKING_KEY = Key.get(RankingFunction.class);
    }

    ElementAnalyzer(Binder binder) {
        this.binder = binder;
    }

    public void ignoreKeys(Set<Key<?>> keys) {
        this.localKeys.addAll(keys);
    }

    public void apply(Wiring wiring) {
        Set<Key<?>> missingKeys = this.analyzer.findMissingKeys(this.localKeys);
        MergedProperties mergedProperties = new MergedProperties(this.properties);
        for (Key<?> key : missingKeys) {
            if (ElementAnalyzer.isParameters(key.getAnnotationType())) {
                this.wireParameters(key, mergedProperties);
                continue;
            }
            wiring.wire(key);
        }
        for (ElementAnalyzer privateAnalyzer : this.privateAnalyzers) {
            privateAnalyzer.ignoreKeys(this.localKeys);
            privateAnalyzer.ignoreKeys(missingKeys);
            privateAnalyzer.apply(wiring);
        }
    }

    public <T> Void visit(Binding<T> binding) {
        Key key = binding.getKey();
        if (!this.localKeys.contains(key)) {
            if (ElementAnalyzer.isParameters(key.getAnnotationType())) {
                this.mergeParameters(binding);
            } else if (((Boolean)binding.acceptTargetVisitor((BindingTargetVisitor)this.analyzer)).booleanValue()) {
                this.localKeys.add(key);
                binding.applyTo(this.binder);
                if (LEGACY_RANKING_KEY != null && key.equals(LEGACY_RANKING_KEY) && this.localKeys.add(RANKING_KEY)) {
                    this.binder.bind(RANKING_KEY).to(LEGACY_RANKING_KEY);
                }
            } else {
                Logs.trace("Discard binding: {}", binding, null);
            }
        }
        return null;
    }

    public Void visit(PrivateElements elements) {
        PrivateBinder privateBinder = this.binder.withSource(elements.getSource()).newPrivateBinder();
        ElementAnalyzer privateAnalyzer = new ElementAnalyzer((Binder)privateBinder);
        this.privateAnalyzers.add(privateAnalyzer);
        privateAnalyzer.ignoreKeys(this.localKeys);
        for (Element e : elements.getElements()) {
            e.acceptVisitor((ElementVisitor)privateAnalyzer);
        }
        for (Key k : elements.getExposedKeys()) {
            if (!privateAnalyzer.localKeys.contains(k) || !this.localKeys.add(k)) continue;
            privateBinder.withSource(elements.getExposedSource(k)).expose(k);
        }
        return null;
    }

    public <T> Void visit(ProviderLookup<T> lookup) {
        this.analyzer.visit(lookup);
        lookup.applyTo(this.binder);
        return null;
    }

    public Void visit(StaticInjectionRequest request) {
        this.analyzer.visit(request);
        request.applyTo(this.binder);
        return null;
    }

    public Void visit(InjectionRequest<?> request) {
        this.analyzer.visit(request);
        request.applyTo(this.binder);
        return null;
    }

    public Void visitOther(Element element) {
        element.applyTo(this.binder);
        return null;
    }

    private void mergeParameters(Binding<?> binding) {
        Object parameters = null;
        if (binding instanceof InstanceBinding) {
            parameters = ((InstanceBinding)binding).getInstance();
        } else if (binding instanceof ProviderInstanceBinding) {
            parameters = ((ProviderInstanceBinding)binding).getProviderInstance().get();
        }
        if (parameters instanceof Map) {
            this.properties.add((Map)parameters);
        } else if (parameters instanceof String[]) {
            Collections.addAll(this.arguments, (String[])parameters);
        } else {
            Logs.warn("Ignoring incompatible @Parameters binding: {}", binding, null);
        }
    }

    private void wireParameters(Key key, Map mergedProperties) {
        TypeLiteral type = key.getTypeLiteral();
        Class clazz = type.getRawType();
        if (Map.class == clazz) {
            TypeLiteral<?>[] constraints = TypeParameters.get(type);
            if (constraints.length == 2 && String.class == constraints[1].getRawType()) {
                this.binder.bind(key).toInstance((Object)new StringProperties(mergedProperties));
            } else {
                this.binder.bind(key).toInstance((Object)mergedProperties);
            }
        } else if (String[].class == clazz) {
            this.binder.bind(key).toInstance((Object)this.arguments.toArray(new String[this.arguments.size()]));
        }
    }

    private static boolean isParameters(Class<? extends Annotation> qualifierType) {
        return Parameters.class == qualifierType || org.sonatype.inject.Parameters.class == qualifierType;
    }
}

