/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.spi.Element;
import com.google.inject.spi.Elements;
import com.google.inject.spi.MembersInjectorLookup;
import com.google.inject.spi.ProviderLookup;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sisu.BeanScanning;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.ClassSpaceScanner;
import org.eclipse.sisu.space.ClassSpaceVisitor;
import org.eclipse.sisu.space.QualifiedTypeBinder;
import org.eclipse.sisu.space.QualifiedTypeVisitor;
import org.eclipse.sisu.space.SisuIndexClassFinder;

public class SpaceModule
implements Module {
    private static Map<String, List<Element>> cachedElementsMap;
    final ClassSpace space;
    private final BeanScanning scanning;

    public SpaceModule(ClassSpace space) {
        this(space, BeanScanning.ON);
    }

    public SpaceModule(ClassSpace space, BeanScanning scanning) {
        this.space = space;
        this.scanning = scanning;
    }

    public final void configure(Binder binder) {
        ClassSpaceScanner scanner;
        binder.bind(ClassSpace.class).toInstance((Object)this.space);
        switch (this.scanning) {
            default: {
                scanner = new ClassSpaceScanner(this.space);
                break;
            }
            case INDEX: {
                scanner = new ClassSpaceScanner(new SisuIndexClassFinder(false), this.space);
                break;
            }
            case GLOBAL_INDEX: {
                scanner = new ClassSpaceScanner(new SisuIndexClassFinder(true), this.space);
                break;
            }
            case CACHE: {
                this.replayCachedElements(binder);
                return;
            }
            case OFF: {
                return;
            }
        }
        scanner.accept(this.visitor(binder));
    }

    protected ClassSpaceVisitor visitor(Binder binder) {
        return new QualifiedTypeVisitor(new QualifiedTypeBinder(binder));
    }

    private final synchronized void replayCachedElements(Binder binder) {
        if (cachedElementsMap == null) {
            cachedElementsMap = new HashMap<String, List<Element>>();
        }
        String key = this.space.toString();
        List elements = cachedElementsMap.get(key);
        boolean replaying = true;
        if (elements == null) {
            replaying = false;
            elements = Elements.getElements((Module[])new Module[]{new Module(){

                public void configure(Binder recorder) {
                    new ClassSpaceScanner(SpaceModule.this.space).accept(SpaceModule.this.visitor(recorder));
                }
            }});
            cachedElementsMap.put(key, elements);
        }
        for (Element e : elements) {
            if (replaying) {
                if (e instanceof ProviderLookup) {
                    binder.getProvider(((ProviderLookup)e).getKey());
                    continue;
                }
                if (e instanceof MembersInjectorLookup) {
                    binder.getMembersInjector(((MembersInjectorLookup)e).getType());
                    continue;
                }
            }
            e.applyTo(binder);
        }
    }
}

