/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Qualifier;
import org.eclipse.sisu.space.AnnotationVisitor;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.ClassSpaceScanner;
import org.eclipse.sisu.space.ClassVisitor;

final class QualifierCache
implements ClassVisitor {
    private static final String QUALIFIER_DESC = String.valueOf('L') + Qualifier.class.getName().replace('.', '/') + ';';
    private static final Map<String, Boolean> cachedResults = new ConcurrentHashMap<String, Boolean>(32, 0.75f, 1);
    private boolean isQualified;

    QualifierCache() {
    }

    public void enter(int modifiers, String name, String _extends, String[] _implements) {
    }

    public AnnotationVisitor visitAnnotation(String desc) {
        this.isQualified |= QUALIFIER_DESC.equals(desc);
        return null;
    }

    public void leave() {
    }

    boolean qualify(ClassSpace space, String desc) {
        Boolean result = cachedResults.get(desc);
        if (result == null) {
            this.isQualified = false;
            String name = desc.substring(1, desc.length() - 1);
            ClassSpaceScanner.accept(this, space.getResource(String.valueOf(name) + ".class"));
            cachedResults.put(desc, this.isQualified);
            return this.isQualified;
        }
        return result;
    }
}

