/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.space.ClassFinder;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.Streams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedClassFinder
implements ClassFinder {
    private final String indexPath;
    private final String indexName;

    public IndexedClassFinder(String name, boolean globalIndex) {
        if (globalIndex) {
            this.indexPath = null;
            this.indexName = name;
        } else {
            int i = name.lastIndexOf(47) + 1;
            this.indexPath = name.substring(0, i);
            this.indexName = name.substring(i);
        }
    }

    @Override
    public Enumeration<URL> findClasses(ClassSpace space) {
        ArrayList<URL> components = new ArrayList<URL>();
        HashSet<String> visited = new HashSet<String>();
        Enumeration<URL> indices = this.indexPath == null ? space.getResources(this.indexName) : space.findEntries(this.indexPath, this.indexName, false);
        while (indices.hasMoreElements()) {
            URL url = indices.nextElement();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(Streams.open(url), "UTF-8"));
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        URL clazz;
                        if (visited.add(line) && (clazz = space.getResource(String.valueOf(line.replace('.', '/')) + ".class")) != null) {
                            components.add(clazz);
                        }
                        line = reader.readLine();
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                Logs.warn("Problem reading: {}", url, e);
            }
        }
        return Collections.enumeration(components);
    }
}

