/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.BindingTargetVisitor;
import java.util.List;
import java.util.Map;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.BindingSubscriber;
import org.eclipse.sisu.inject.HiddenBinding;
import org.eclipse.sisu.inject.ImplementationVisitor;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.inject.RankingFunction;
import org.eclipse.sisu.inject.TypeParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InjectorPublisher
implements BindingPublisher {
    private static final TypeLiteral<?> OBJECT_TYPE_LITERAL = TypeLiteral.get(Object.class);
    private final Injector injector;
    private final RankingFunction function;

    InjectorPublisher(Injector injector, RankingFunction function) {
        this.injector = injector;
        this.function = function;
    }

    public Injector getInjector() {
        return this.injector;
    }

    @Override
    public <T> void subscribe(BindingSubscriber<T> subscriber) {
        TypeLiteral<T> type = subscriber.type();
        this.publishBindings(type, subscriber, null);
        Class clazz = type.getRawType();
        if (clazz != type.getType()) {
            this.publishBindings(TypeLiteral.get((Class)clazz), subscriber, type);
        }
        if (clazz != Object.class) {
            this.publishBindings(OBJECT_TYPE_LITERAL, subscriber, type);
        }
    }

    @Override
    public <T> void unsubscribe(BindingSubscriber<T> subscriber) {
        Map ourBindings = this.injector.getBindings();
        for (Binding<T> binding : subscriber.bindings()) {
            if (binding != ourBindings.get(binding.getKey())) continue;
            subscriber.remove(binding);
        }
    }

    public int hashCode() {
        return this.injector.hashCode();
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof InjectorPublisher) {
            return this.injector.equals(((InjectorPublisher)rhs).injector);
        }
        return false;
    }

    public String toString() {
        return Logs.toString(this.injector);
    }

    static boolean isVisible(Binding<?> binding) {
        return !(binding.getSource() instanceof HiddenBinding);
    }

    private static boolean isAssignableFrom(TypeLiteral<?> superType, Binding<?> binding) {
        Class implementation = (Class)binding.acceptTargetVisitor((BindingTargetVisitor)ImplementationVisitor.THIS);
        if (implementation != null && superType.getRawType() != implementation) {
            return TypeParameters.isAssignableFrom(superType, TypeLiteral.get((Class)implementation));
        }
        return false;
    }

    private void publishBindings(TypeLiteral searchType, BindingSubscriber subscriber, TypeLiteral superType) {
        List bindings = this.injector.findBindingsByType(searchType);
        int i = 0;
        int size = bindings.size();
        while (i < size) {
            Binding binding = (Binding)bindings.get(i);
            if (InjectorPublisher.isVisible(binding) && (superType == null || InjectorPublisher.isAssignableFrom(superType, binding))) {
                subscriber.add(binding, this.function.rank(binding));
            }
            ++i;
        }
    }
}

