/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.scanners;

import com.google.inject.Module;
import java.net.URL;
import javax.inject.Qualifier;
import org.eclipse.sisu.reflect.ClassSpace;
import org.eclipse.sisu.reflect.Logs;
import org.eclipse.sisu.scanners.ClassSpaceScanner;
import org.eclipse.sisu.scanners.ClassSpaceVisitor;
import org.eclipse.sisu.scanners.EmptyClassVisitor;
import org.eclipse.sisu.scanners.QualifiedTypeListener;
import org.eclipse.sisu.scanners.QualifierCache;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;

public final class QualifiedTypeVisitor
extends EmptyClassVisitor
implements ClassSpaceVisitor {
    private final QualifierCache qualifierCache = new QualifierCache();
    private final QualifiedTypeListener listener;
    private ClassSpace space;
    private URL location;
    private String source;
    private String clazzName;
    private boolean qualified;

    public QualifiedTypeVisitor(QualifiedTypeListener listener) {
        this.listener = listener;
    }

    public void visit(ClassSpace _space) {
        this.space = _space;
        this.source = null;
        if (Logs.DEBUG_ENABLED) {
            ClassSpaceScanner.verify(_space, Qualifier.class, Module.class);
        }
    }

    public ClassVisitor visitClass(URL url) {
        this.location = url;
        this.clazzName = null;
        this.qualified = false;
        return this;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if ((access & 0x1600) == 0) {
            this.clazzName = name;
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.clazzName != null) {
            this.qualified = this.qualified || this.qualifierCache.qualify(this.space, desc);
        }
        return null;
    }

    public void visitEnd() {
        if (this.qualified) {
            this.qualified = false;
            String path = this.location.getPath();
            if (this.source == null || !path.startsWith(this.source)) {
                int i = path.indexOf(this.clazzName);
                this.source = i <= 0 ? path : path.substring(0, i);
            }
            this.listener.hear(null, this.space.loadClass(this.clazzName.replace('/', '.')), this.source);
        }
    }
}

