/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.scanners;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.sisu.reflect.ClassSpace;
import org.eclipse.sisu.reflect.Logs;
import org.eclipse.sisu.scanners.ClassFinder;
import org.eclipse.sisu.scanners.ClassSpaceVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public final class ClassSpaceScanner {
    private static final int ASM_FLAGS = 7;
    private final ClassFinder finder;
    private final ClassSpace space;

    public ClassSpaceScanner(ClassSpace space) {
        this(null, space);
    }

    public ClassSpaceScanner(ClassFinder finder, ClassSpace space) {
        this.finder = finder;
        this.space = space;
    }

    public void accept(ClassSpaceVisitor visitor) {
        visitor.visit(this.space);
        Enumeration<URL> result = this.finder != null ? this.finder.findClasses(this.space) : this.space.findEntries(null, "*.class", true);
        while (result.hasMoreElements()) {
            URL url = result.nextElement();
            ClassVisitor cv = visitor.visitClass(url);
            if (cv == null) continue;
            ClassSpaceScanner.accept(cv, url);
        }
        visitor.visitEnd();
    }

    public static void accept(ClassVisitor visitor, URL url) {
        if (url == null) {
            return;
        }
        try {
            InputStream in = url.openStream();
            try {
                new ClassReader(in).accept(visitor, 7);
            }
            finally {
                in.close();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (Exception e) {
            Logs.debug("Problem scanning: {}", url, e);
        }
    }

    public static boolean verify(ClassSpace space, Class<?> ... specification) {
        Class<?>[] classArray = specification;
        int n = specification.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                Class<?> expectedClazz = classArray[n2];
                try {
                    Class<?> spaceClazz = space.loadClass(expectedClazz.getName());
                    if (spaceClazz != expectedClazz) {
                        Logs.warn("Inconsistent ClassLoader for: {} in: {}", expectedClazz, space);
                        Logs.warn("Expected: {} saw: {}", expectedClazz.getClassLoader(), spaceClazz.getClassLoader());
                    }
                }
                catch (TypeNotPresentException typeNotPresentException) {
                    if (!expectedClazz.isAnnotation()) break block4;
                    Logs.debug("Potential problem: {} is not visible from: {}", expectedClazz, space);
                }
            }
            ++n2;
        }
        return true;
    }
}

